/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.api.persistents;

import io.icker.factions.api.events.ClaimEvents;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.User;
import io.icker.factions.database.Database;
import io.icker.factions.database.Field;
import io.icker.factions.database.Name;
import io.icker.factions.util.WorldUtils;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

@Name(value="Claim")
public class Claim {
    private static final HashMap<String, Claim> STORE = Database.load(Claim.class, c -> c.getKey());
    @Field(value="X")
    public int x;
    @Field(value="Z")
    public int z;
    @Field(value="Level")
    public String level;
    @Field(value="FactionID")
    public UUID factionID;
    @Field(value="AccessLevel")
    public User.Rank accessLevel;

    public Claim(int x, int z, String level, UUID factionID) {
        this.x = x;
        this.z = z;
        this.level = level;
        this.factionID = factionID;
        this.accessLevel = User.Rank.MEMBER;
    }

    public Claim() {
    }

    public String getKey() {
        return String.format("%s-%d-%d", this.level, this.x, this.z);
    }

    public static Claim get(int x, int z, String level) {
        return STORE.get(String.format("%s-%d-%d", level, x, z));
    }

    public static List<Claim> getByFaction(UUID factionID) {
        return STORE.values().stream().filter(c -> c.factionID.equals(factionID)).toList();
    }

    public static void audit() {
        STORE.values().removeIf(claim -> Faction.get(claim.factionID) == null || !WorldUtils.isValid(claim.level));
    }

    public static void add(Claim claim) {
        STORE.put(claim.getKey(), claim);
        ((ClaimEvents.Add)ClaimEvents.ADD.invoker()).onAdd(claim);
    }

    public Faction getFaction() {
        return Faction.get(this.factionID);
    }

    public void remove() {
        STORE.remove(this.getKey());
        ((ClaimEvents.Remove)ClaimEvents.REMOVE.invoker()).onRemove(this.x, this.z, this.level, Faction.get(this.factionID));
    }

    public static void save() {
        Database.save(Claim.class, STORE.values().stream().toList());
    }
}

