/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.icker.factions.FactionsMod;
import io.icker.factions.api.persistents.Claim;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.User;
import io.icker.factions.util.Command;
import io.icker.factions.util.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ClaimCommand
implements Command {
    private int list(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        List<Claim> claims = Command.getUser(player).getFaction().getClaims();
        int count = claims.size();
        new Message(class_2561.method_43469((String)"factions.command.claim.list", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(count)).method_27692(class_124.field_1054)})).send((class_1657)source.method_9207(), false);
        if (count == 0) {
            return 1;
        }
        HashMap<String, ArrayList> claimsMap = new HashMap<String, ArrayList>();
        claims.forEach(claim -> {
            claimsMap.putIfAbsent(claim.level, new ArrayList());
            ((ArrayList)claimsMap.get(claim.level)).add(claim);
        });
        Message claimText = new Message();
        claimsMap.forEach((level, array) -> {
            claimText.add("\n");
            claimText.add(new Message(class_2561.method_43471((String)("factions.level." + level))).format(class_124.field_1080));
            claimText.filler("\u00bb");
            claimText.add(array.stream().map(claim -> String.format("(%d,%d)", claim.x, claim.z)).collect(Collectors.joining(", ")));
        });
        claimText.format(class_124.field_1056).send((class_1657)source.method_9207(), false);
        return 1;
    }

    private int addForced(CommandContext<class_2168> context, int size) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_3218 world = player.method_51469();
        Faction faction = Command.getUser(player).getFaction();
        String dimension = world.method_27983().method_29177().toString();
        ArrayList<class_1923> chunks = new ArrayList<class_1923>();
        for (int x = -size + 1; x < size; ++x) {
            for (int y = -size + 1; y < size; ++y) {
                class_1923 chunkPos = world.method_22350(player.method_24515().method_10069(x * 16, 0, y * 16)).method_12004();
                Claim existingClaim = Claim.get(chunkPos.field_9181, chunkPos.field_9180, dimension);
                if (existingClaim != null) {
                    if (size == 1) {
                        boolean isActorOwner = existingClaim.getFaction().equals(faction);
                        new Message(class_2561.method_43469((String)"factions.command.claim.add.fail.already_owned.single", (Object[])new Object[]{class_2561.method_43471((String)("factions.command.claim.add.fail.already_owned.single." + (isActorOwner ? "your" : "another")))})).fail().send((class_1657)player, false);
                        return 0;
                    }
                    if (!existingClaim.getFaction().equals(faction)) {
                        new Message(class_2561.method_43471((String)"factions.command.claim.add.fail.already_owned.multiple")).fail().send((class_1657)player, false);
                        return 0;
                    }
                }
                chunks.add(chunkPos);
            }
        }
        chunks.forEach(chunk -> faction.addClaim(chunk.field_9181, chunk.field_9180, dimension));
        if (size == 1) {
            new Message(class_2561.method_43469((String)"factions.command.claim.add.success.single", (Object[])new Object[]{((class_1923)chunks.get((int)0)).field_9181, ((class_1923)chunks.get((int)0)).field_9180, player.method_5477().getString()})).send(faction);
        } else {
            new Message(class_2561.method_43469((String)"factions.command.claim.add.success.multiple", (Object[])new Object[]{((class_1923)chunks.get((int)0)).field_9181, ((class_1923)chunks.get((int)0)).field_9180, ((class_1923)chunks.get((int)0)).field_9181 + size - 1, ((class_1923)chunks.get((int)0)).field_9180 + size - 1, player.method_5477().getString()})).send(faction);
        }
        return 1;
    }

    private int add(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Faction faction = Command.getUser(player).getFaction();
        int requiredPower = (faction.getClaims().size() + 1) * FactionsMod.CONFIG.POWER.CLAIM_WEIGHT;
        int maxPower = faction.getUsers().size() * FactionsMod.CONFIG.POWER.MEMBER + FactionsMod.CONFIG.POWER.BASE + faction.getAdminPower();
        if (maxPower < requiredPower) {
            new Message(class_2561.method_43471((String)"factions.command.claim.add.fail.lacks_power")).fail().send((class_1657)player, false);
            return 0;
        }
        return this.addForced(context, 1);
    }

    private int addSize(CommandContext<class_2168> context) throws CommandSyntaxException {
        int size = IntegerArgumentType.getInteger(context, (String)"size");
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Faction faction = Command.getUser(player).getFaction();
        int requiredPower = (faction.getClaims().size() + 1) * FactionsMod.CONFIG.POWER.CLAIM_WEIGHT;
        int maxPower = faction.getUsers().size() * FactionsMod.CONFIG.POWER.MEMBER + FactionsMod.CONFIG.POWER.BASE + faction.getAdminPower();
        if (maxPower < requiredPower) {
            new Message(class_2561.method_43471((String)"factions.command.claim.add.fail.lacks_power.multiple")).fail().send((class_1657)player, false);
            return 0;
        }
        return this.addForced(context, size);
    }

    private int remove(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_3218 world = player.method_51469();
        class_1923 chunkPos = world.method_22350(player.method_24515()).method_12004();
        String dimension = world.method_27983().method_29177().toString();
        Claim existingClaim = Claim.get(chunkPos.field_9181, chunkPos.field_9180, dimension);
        if (existingClaim == null) {
            new Message(class_2561.method_43471((String)"factions.command.claim.remove.fail.unclaimed")).fail().send((class_1657)player, false);
            return 0;
        }
        User user = Command.getUser(player);
        Faction faction = user.getFaction();
        if (!user.bypass && existingClaim.getFaction().getID() != faction.getID()) {
            new Message(class_2561.method_43471((String)"factions.command.claim.remove.fail.another_owner")).fail().send((class_1657)player, false);
            return 0;
        }
        existingClaim.remove();
        new Message(class_2561.method_43469((String)"factions.command.claim.remove.success.single", (Object[])new Object[]{existingClaim.x, existingClaim.z, player.method_5477().getString()})).send(faction);
        return 1;
    }

    private int removeSize(CommandContext<class_2168> context) throws CommandSyntaxException {
        int size = IntegerArgumentType.getInteger(context, (String)"size");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_3218 world = player.method_51469();
        String dimension = world.method_27983().method_29177().toString();
        User user = Command.getUser(player);
        Faction faction = user.getFaction();
        for (int x = -size + 1; x < size; ++x) {
            for (int y = -size + 1; y < size; ++y) {
                class_1923 chunkPos = world.method_22350(player.method_24515().method_10069(x * 16, 0, y * 16)).method_12004();
                Claim existingClaim = Claim.get(chunkPos.field_9181, chunkPos.field_9180, dimension);
                if (existingClaim == null || !user.bypass && !existingClaim.getFaction().equals(faction)) continue;
                existingClaim.remove();
            }
        }
        class_1923 chunkPos = world.method_22350(player.method_24515().method_10069((-size + 1) * 16, 0, (-size + 1) * 16)).method_12004();
        new Message(class_2561.method_43469((String)"factions.command.claim.remove.success.multiple", (Object[])new Object[]{chunkPos.field_9181, chunkPos.field_9180, chunkPos.field_9181 + size - 1, chunkPos.field_9180 + size - 1, player.method_5477().getString()})).send(faction);
        return 1;
    }

    private int removeAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Faction faction = Command.getUser(player).getFaction();
        faction.removeAllClaims();
        new Message(class_2561.method_43469((String)"factions.command.claim.remove.success.all", (Object[])new Object[]{player.method_5477().getString()})).send(faction);
        return 1;
    }

    private int auto(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        User user = Command.getUser(player);
        user.autoclaim = !user.autoclaim;
        new Message(class_2561.method_43471((String)"factions.command.claim.auto.toggled")).filler("\u00b7").add(new Message(class_2561.method_43471((String)("options." + (user.autoclaim ? "on" : "off")))).format(user.autoclaim ? class_124.field_1060 : class_124.field_1061)).send((class_1657)player, false);
        return 1;
    }

    private int setAccessLevel(CommandContext<class_2168> context, boolean increase) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_3218 world = player.method_51469();
        class_1923 chunkPos = world.method_22350(player.method_24515()).method_12004();
        String dimension = world.method_27983().method_29177().toString();
        Claim claim = Claim.get(chunkPos.field_9181, chunkPos.field_9180, dimension);
        if (claim == null) {
            new Message(class_2561.method_43471((String)"factions.command.claim.set_access_level.fail.unclaimed")).fail().send((class_1657)player, false);
            return 0;
        }
        User user = Command.getUser(player);
        Faction faction = user.getFaction();
        if (!user.bypass && claim.getFaction().getID() != faction.getID()) {
            new Message(class_2561.method_43471((String)"factions.command.claim.set_access_level.fail.another_owner")).fail().send((class_1657)player, false);
            return 0;
        }
        if (increase) {
            if (claim.accessLevel.ordinal() <= user.rank.ordinal()) {
                new Message(class_2561.method_43471((String)"factions.command.claim.set_access_level.fail.max_level_for_rank")).fail().send((class_1657)player, false);
                return 0;
            }
            switch (claim.accessLevel) {
                case OWNER: {
                    new Message(class_2561.method_43471((String)"factions.command.claim.set_access_level.fail.max_level")).fail().send((class_1657)player, false);
                    return 0;
                }
                case LEADER: {
                    claim.accessLevel = User.Rank.OWNER;
                    break;
                }
                case COMMANDER: {
                    claim.accessLevel = User.Rank.LEADER;
                    break;
                }
                case MEMBER: {
                    claim.accessLevel = User.Rank.COMMANDER;
                    break;
                }
                case GUEST: {
                    return 0;
                }
            }
        } else {
            if (claim.accessLevel.ordinal() <= user.rank.ordinal()) {
                new Message(class_2561.method_43471((String)"factions.command.claim.set_access_level.fail.rank_too_low")).fail().send((class_1657)player, false);
                return 0;
            }
            switch (claim.accessLevel) {
                case OWNER: {
                    claim.accessLevel = User.Rank.LEADER;
                    break;
                }
                case LEADER: {
                    claim.accessLevel = User.Rank.COMMANDER;
                    break;
                }
                case COMMANDER: {
                    claim.accessLevel = User.Rank.MEMBER;
                    break;
                }
                case MEMBER: {
                    new Message(class_2561.method_43471((String)"factions.command.claim.set_access_level.fail.min_level")).fail().send((class_1657)player, false);
                    return 0;
                }
                case GUEST: {
                    return 0;
                }
            }
        }
        new Message(class_2561.method_43469((String)"factions.command.claim.set_access_level.success", (Object[])new Object[]{claim.x, claim.z, claim.accessLevel.toString(), player.method_5477().getString()})).send(faction);
        return 1;
    }

    @Override
    public LiteralCommandNode<class_2168> getNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"claim").requires(Command.Requires.isCommander())).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(Command.Requires.hasPerms("factions.claim.add", 0))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)7)).requires(Command.Requires.hasPerms("factions.claim.add.size", 0))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"force").requires(Command.Requires.hasPerms("factions.claim.add.force", 0).and(Command.Requires.isLeader()))).executes(context -> this.addForced((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"size"))))).executes(this::addSize))).executes(this::add))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(Command.Requires.hasPerms("factions.claim.list", 0))).executes(this::list))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(Command.Requires.hasPerms("factions.claim.remove", 0).and(Command.Requires.isLeader()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)7)).requires(Command.Requires.hasPerms("factions.claim.remove.size", 0))).executes(this::removeSize))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").requires(Command.Requires.hasPerms("factions.claim.remove.all", 0))).executes(this::removeAll))).executes(this::remove))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"auto").requires(Command.Requires.hasPerms("factions.claim.auto", 0))).executes(this::auto))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"access").requires(Command.Requires.hasPerms("factions.claim.access", 0))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"increase").requires(Command.Requires.hasPerms("factions.claim.access.increase", 0))).executes(context -> this.setAccessLevel((CommandContext<class_2168>)context, true)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"decrease").requires(Command.Requires.hasPerms("factions.claim.access.decrease", 0))).executes(context -> this.setAccessLevel((CommandContext<class_2168>)context, false))))).build();
    }
}

