/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.icker.factions.FactionsMod;
import io.icker.factions.api.persistents.Claim;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.Home;
import io.icker.factions.api.persistents.User;
import io.icker.factions.mixin.DamageTrackerAccessor;
import io.icker.factions.util.Command;
import io.icker.factions.util.Message;
import io.icker.factions.util.WorldUtils;
import java.time.Instant;
import java.util.Date;
import java.util.HashSet;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class HomeCommand
implements Command {
    private int go(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        if (player == null) {
            return 0;
        }
        User user = Command.getUser(player);
        Faction faction = user.getFaction();
        if (faction == null) {
            return 0;
        }
        return this.execGo(player, user, faction);
    }

    public int execGo(class_3222 player, User user, Faction faction) {
        Home home = faction.getHome();
        if (home == null) {
            new Message(class_2561.method_43471((String)"factions.command.home.warp.fail.no_home")).fail().send((class_1657)player, false);
            return 0;
        }
        if (player.method_51469().method_8503() == null) {
            return 0;
        }
        class_3218 world = WorldUtils.getWorld(home.level);
        if (world == null) {
            new Message(class_2561.method_43471((String)"factions.command.home.warp.fail.no_world")).fail().send((class_1657)player, false);
            return 0;
        }
        if (HomeCommand.checkLimitToClaim(faction, world, class_2338.method_49637((double)home.x, (double)home.y, (double)home.z))) {
            new Message(class_2561.method_43471((String)"factions.command.home.warp.fail.no_claim")).fail().send((class_1657)player, false);
            return 0;
        }
        long elapsed_time = Date.from(Instant.now()).getTime() - user.homeCooldown;
        if (elapsed_time < (long)(FactionsMod.CONFIG.HOME.HOME_WARP_COOLDOWN_SECOND * 1000)) {
            new Message("Cannot warp home while on warp cooldown, please wait %.0f seconds", (double)((long)(FactionsMod.CONFIG.HOME.HOME_WARP_COOLDOWN_SECOND * 1000) - elapsed_time) / 1000.0).fail().send((class_1657)player, false);
            return 0;
        }
        if (((DamageTrackerAccessor)player.method_6066()).getAgeOnLastDamage() == 0 || player.field_6012 - ((DamageTrackerAccessor)player.method_6066()).getAgeOnLastDamage() > FactionsMod.CONFIG.HOME.DAMAGE_COOLDOWN) {
            player.method_48105(world, home.x, home.y, home.z, new HashSet(), home.yaw, home.pitch, false);
            user.homeCooldown = Date.from(Instant.now()).getTime();
            new Message(class_2561.method_43471((String)"factions.command.home.warp.success")).send((class_1657)player, false);
        } else {
            new Message(class_2561.method_43471((String)"factions.command.home.warp.fail.combat")).fail().send((class_1657)player, false);
        }
        return 1;
    }

    private int set(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Faction faction = Command.getUser(player).getFaction();
        if (HomeCommand.checkLimitToClaim(faction, player.method_51469(), player.method_24515())) {
            new Message(class_2561.method_43471((String)"factions.command.home.fail.no_claim")).fail().send((class_1657)player, false);
            return 0;
        }
        Home home = new Home(faction.getID(), player.method_23317(), player.method_23318(), player.method_23321(), player.method_5791(), player.method_36455(), player.method_51469().method_27983().method_29177().toString());
        faction.setHome(home);
        new Message(class_2561.method_43469((String)"factions.command.home.set.success", (Object[])new Object[]{home.x, home.y, home.z, player.method_5477().getString()})).send(faction);
        return 1;
    }

    private static boolean checkLimitToClaim(Faction faction, class_3218 world, class_2338 pos) {
        if (!FactionsMod.CONFIG.HOME.CLAIM_ONLY) {
            return false;
        }
        class_1923 chunkPos = world.method_22350(pos).method_12004();
        String dimension = world.method_27983().method_29177().toString();
        Claim possibleClaim = Claim.get(chunkPos.field_9181, chunkPos.field_9180, dimension);
        return possibleClaim == null || possibleClaim.getFaction().getID() != faction.getID();
    }

    @Override
    public LiteralCommandNode<class_2168> getNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"home").requires(Command.Requires.multiple(Command.Requires.isMember(), s -> FactionsMod.CONFIG.HOME != null, Command.Requires.hasPerms("factions.home", 0)))).executes(this::go)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(Command.Requires.multiple(Command.Requires.hasPerms("factions.home.set", 0), Command.Requires.isLeader()))).executes(this::set))).build();
    }
}

