/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.icker.factions.FactionsMod;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.User;
import io.icker.factions.ui.InfoGui;
import io.icker.factions.util.Command;
import io.icker.factions.util.Message;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_11755;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class InfoCommand
implements Command {
    private int self(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        User user = Command.getUser(player);
        if (!user.isInFaction()) {
            new Message(class_2561.method_43471((String)"factions.command.info.fail.no_faction")).fail().send((class_1657)player, false);
            return 0;
        }
        return InfoCommand.info(player, user.getFaction());
    }

    private int any(CommandContext<class_2168> context) throws CommandSyntaxException {
        String factionName = StringArgumentType.getString(context, (String)"faction");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        Faction faction = Faction.getByName(factionName);
        if (faction == null) {
            new Message(class_2561.method_43471((String)"factions.command.info.fail.nonexistent_faction")).fail().send((class_1657)player, false);
            return 0;
        }
        return InfoCommand.info(player, faction);
    }

    public static int info(class_3222 player, Faction faction) {
        if (FactionsMod.CONFIG.GUI) {
            new InfoGui(player, faction, null);
            return 1;
        }
        List<User> users = faction.getUsers();
        class_11755 resolver = player.method_51469().method_8503().method_73550().comp_4624();
        String owner = String.valueOf(class_124.field_1068) + users.stream().filter(u -> u.rank == User.Rank.OWNER).map(user -> resolver.method_73290(user.getID()).orElse(new GameProfile(class_156.field_25140, "{Uncached Player}")).name()).collect(Collectors.joining(", "));
        String usersList = users.stream().map(user -> resolver.method_73290(user.getID()).orElse(new GameProfile(class_156.field_25140, "{Uncached Player}")).name()).collect(Collectors.joining(", "));
        String mutualAllies = faction.getMutualAllies().stream().map(rel -> Faction.get(rel.target)).map(fac -> String.valueOf(fac.getColor()) + fac.getName()).collect(Collectors.joining(String.valueOf(class_124.field_1080) + ", "));
        String enemiesWith = String.valueOf(class_124.field_1080) + faction.getEnemiesWith().stream().map(rel -> Faction.get(rel.target)).map(fac -> String.valueOf(fac.getColor()) + fac.getName()).collect(Collectors.joining(String.valueOf(class_124.field_1080) + ", "));
        int requiredPower = faction.getClaims().size() * FactionsMod.CONFIG.POWER.CLAIM_WEIGHT;
        int maxPower = users.size() * FactionsMod.CONFIG.POWER.MEMBER + FactionsMod.CONFIG.POWER.BASE;
        int numDashes = 32 - faction.getName().length();
        String dashes = new StringBuilder("--------------------------------").substring(0, numDashes / 2);
        new Message(String.valueOf(class_124.field_1074) + dashes + "[ " + String.valueOf(faction.getColor()) + faction.getName() + String.valueOf(class_124.field_1074) + " ]" + dashes).send((class_1657)player, false);
        new Message(class_2561.method_43471((String)"factions.gui.info.description").method_27692(class_124.field_1065)).add(String.valueOf(class_124.field_1068) + faction.getDescription()).send((class_1657)player, false);
        new Message(class_2561.method_43471((String)"factions.gui.info.owner").method_27692(class_124.field_1065)).add(String.valueOf(class_124.field_1068) + owner).send((class_1657)player, false);
        new Message(class_2561.method_43469((String)"factions.gui.info.members", (Object[])new Object[]{class_2561.method_43470((String)Integer.toString(users.size())).method_27692(class_124.field_1068)}).method_27692(class_124.field_1065)).add(usersList).send((class_1657)player, false);
        new Message(class_2561.method_43471((String)"factions.gui.info.power").method_27692(class_124.field_1065)).add(class_124.field_1060.toString() + faction.getPower() + InfoCommand.slash() + requiredPower + InfoCommand.slash() + maxPower).hover((class_2561)class_2561.method_43471((String)"factions.gui.info.power.description")).send((class_1657)player, false);
        new Message(class_2561.method_43469((String)"factions.gui.info.allies.some", (Object[])new Object[]{class_2561.method_43470((String)Integer.toString(faction.getMutualAllies().size())).method_27692(class_124.field_1068)}).method_27692(class_124.field_1060)).add(mutualAllies).send((class_1657)player, false);
        new Message(class_2561.method_43469((String)"factions.gui.info.enemies.some", (Object[])new Object[]{class_2561.method_43470((String)Integer.toString(faction.getEnemiesWith().size())).method_27692(class_124.field_1068)}).method_27692(class_124.field_1061)).add(enemiesWith).send((class_1657)player, false);
        return 1;
    }

    private static String slash() {
        return String.valueOf(class_124.field_1080) + " / " + String.valueOf(class_124.field_1060);
    }

    @Override
    public LiteralCommandNode<class_2168> getNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(Command.Requires.hasPerms("factions.info", 0))).executes(this::self)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"faction", (ArgumentType)StringArgumentType.greedyString()).requires(Command.Requires.hasPerms("factions.info.other", 0))).suggests(Command.Suggests.allFactions()).executes(this::any))).build();
    }
}

