/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.User;
import io.icker.factions.util.Command;
import io.icker.factions.util.Message;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import xyz.nucleoid.server.translations.api.Localization;

public class RankCommand
implements Command {
    private int promote(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(context, (String)"player");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        if (target.method_5667().equals(player.method_5667())) {
            new Message(class_2561.method_43471((String)"factions.command.rank.promote.fail.self")).fail().send((class_1657)player, false);
            return 0;
        }
        Faction faction = Command.getUser(player).getFaction();
        for (User user : faction.getUsers()) {
            if (!user.getID().equals(target.method_5667())) continue;
            try {
                RankCommand.execPromote(user, player);
            }
            catch (Exception e) {
                new Message(e.getMessage()).fail().send((class_1657)player, false);
                return 0;
            }
            ((class_2168)context.getSource()).method_9211().method_3760().method_14576(target);
            new Message(class_2561.method_43469((String)"factions.command.rank.promote.success", (Object[])new Object[]{target.method_5477().getString(), class_2561.method_43471((String)("factions.command.rank." + User.get(target.method_5667()).getRankName()))})).prependFaction(faction).send((class_1657)player, false);
            return 1;
        }
        new Message(class_2561.method_43469((String)"factions.command.rank.promote.fail.not_in_faction", (Object[])new Object[]{target.method_5477().getString()})).fail().send((class_1657)player, false);
        return 0;
    }

    public static void execPromote(User target, class_3222 initiator) throws Exception {
        switch (target.rank) {
            case GUEST: {
                target.rank = User.Rank.MEMBER;
                break;
            }
            case MEMBER: {
                target.rank = User.Rank.COMMANDER;
                break;
            }
            case COMMANDER: {
                target.rank = User.Rank.LEADER;
                break;
            }
            case LEADER: {
                throw new Exception(Localization.raw((String)"factions.command.rank.promote.fail.leader", (class_3222)initiator));
            }
            case OWNER: {
                throw new Exception(Localization.raw((String)"factions.command.rank.promote.fail.owner", (class_3222)initiator));
            }
        }
    }

    private int demote(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(context, (String)"player");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        if (target.method_5667().equals(player.method_5667())) {
            new Message(class_2561.method_43471((String)"factions.command.rank.demote.fail.self")).fail().send((class_1657)player, false);
            return 0;
        }
        Faction faction = Command.getUser(player).getFaction();
        for (User user : faction.getUsers()) {
            if (!user.getID().equals(target.method_5667())) continue;
            try {
                RankCommand.execDemote(user, player);
            }
            catch (Exception e) {
                new Message(e.getMessage()).fail().send((class_1657)player, false);
                return 0;
            }
            ((class_2168)context.getSource()).method_9211().method_3760().method_14576(target);
            new Message(class_2561.method_43469((String)"factions.command.rank.demote.success", (Object[])new Object[]{target.method_5477().getString(), class_2561.method_43471((String)("factions.command.rank." + User.get(target.method_5667()).getRankName()))})).prependFaction(faction).send((class_1657)player, false);
            return 1;
        }
        new Message(class_2561.method_43469((String)"factions.command.rank.demote.fail.not_in_faction", (Object[])new Object[]{target.method_5477().getString()})).fail().send((class_1657)player, false);
        return 0;
    }

    public static void execDemote(User target, class_3222 initiator) throws Exception {
        switch (target.rank) {
            case GUEST: {
                throw new Exception(Localization.raw((String)"factions.command.rank.demote.fail.guest", (class_3222)initiator));
            }
            case MEMBER: {
                target.rank = User.Rank.GUEST;
                break;
            }
            case COMMANDER: {
                target.rank = User.Rank.MEMBER;
                break;
            }
            case LEADER: {
                if (Command.getUser((class_3222)initiator).rank == User.Rank.LEADER) {
                    throw new Exception(Localization.raw((String)"factions.command.rank.demote.fail.leader", (class_3222)initiator));
                }
                target.rank = User.Rank.COMMANDER;
                break;
            }
            case OWNER: {
                throw new Exception(Localization.raw((String)"factions.command.rank.demote.fail.owner", (class_3222)initiator));
            }
        }
    }

    private int transfer(CommandContext<class_2168> context) throws CommandSyntaxException {
        UUID targetFaction;
        class_3222 target = class_2186.method_9315(context, (String)"player");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        if (target.method_5667().equals(player.method_5667())) {
            new Message(class_2561.method_43471((String)"factions.command.rank.transfer.fail.self")).fail().send((class_1657)player, false);
            return 0;
        }
        User targetUser = User.get(target.method_5667());
        UUID uUID = targetFaction = targetUser.isInFaction() ? targetUser.getFaction().getID() : null;
        if (Command.getUser(player).getFaction().getID().equals(targetFaction)) {
            targetUser.rank = User.Rank.OWNER;
            Command.getUser((class_3222)player).rank = User.Rank.LEADER;
            ((class_2168)context.getSource()).method_9211().method_3760().method_14576(player);
            ((class_2168)context.getSource()).method_9211().method_3760().method_14576(target);
            new Message(class_2561.method_43469((String)"factions.command.rank.transfer.success", (Object[])new Object[]{target.method_5477().getString()})).prependFaction(Faction.get(targetFaction)).send((class_1657)player, false);
            return 1;
        }
        new Message(class_2561.method_43469((String)"factions.command.rank.transfer.fail.not_in_faction", (Object[])new Object[]{target.method_5477().getString()})).fail().send((class_1657)player, false);
        return 0;
    }

    @Override
    public LiteralCommandNode<class_2168> getNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rank").requires(Command.Requires.isLeader())).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"promote").requires(Command.Requires.hasPerms("factions.rank.promote", 0))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(this::promote)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"demote").requires(Command.Requires.hasPerms("factions.rank.demote", 0))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(this::demote)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"transfer").requires(Command.Requires.multiple(Command.Requires.hasPerms("factions.rank.transfer", 0), Command.Requires.isOwner()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(this::transfer)))).build();
    }
}

