/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import io.icker.factions.FactionsMod;
import io.icker.factions.api.persistents.Relationship;
import io.icker.factions.config.HomeConfig;
import io.icker.factions.config.PowerConfig;
import io.icker.factions.config.SafeConfig;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static final int REQUIRED_VERSION = 3;
    private static final File file = FabricLoader.getInstance().getGameDir().resolve("config").resolve("factions.json").toFile();
    @SerializedName(value="version")
    public int VERSION = 3;
    @SerializedName(value="gui")
    public boolean GUI = true;
    @SerializedName(value="blockTNT")
    public boolean BLOCK_TNT = false;
    @SerializedName(value="power")
    public PowerConfig POWER = new PowerConfig();
    @SerializedName(value="safe")
    @Nullable
    public SafeConfig SAFE = new SafeConfig();
    @SerializedName(value="home")
    @Nullable
    public HomeConfig HOME = new HomeConfig();
    @SerializedName(value="display")
    public DisplayConfig DISPLAY = new DisplayConfig();
    @SerializedName(value="relationships")
    public RelationshipConfig RELATIONSHIPS = new RelationshipConfig();
    @SerializedName(value="maxFactionSize")
    public int MAX_FACTION_SIZE = -1;
    @SerializedName(value="friendlyFire")
    public boolean FRIENDLY_FIRE = false;
    @SerializedName(value="requiredBypassLevel")
    public int REQUIRED_BYPASS_LEVEL = 2;
    @SerializedName(value="claimProtections")
    public boolean CLAIM_PROTECTION = true;
    @SerializedName(value="language")
    public String LANGUAGE = "en_us";

    public static Config load() {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().registerTypeAdapter(HomeConfig.class, new Deserializer<HomeConfig>(HomeConfig.class)).registerTypeAdapter(PowerConfig.class, new Deserializer<PowerConfig>(PowerConfig.class)).registerTypeAdapter(SafeConfig.class, new Deserializer<SafeConfig>(SafeConfig.class)).create();
        try {
            if (!file.exists()) {
                file.getParentFile().mkdir();
                Config defaults = new Config();
                FileWriter writer = new FileWriter(file);
                gson.toJson((Object)defaults, (Appendable)writer);
                writer.close();
                return defaults;
            }
            Config config = (Config)gson.fromJson((Reader)new FileReader(file), Config.class);
            if (config.VERSION != 3) {
                FactionsMod.LOGGER.error(String.format("Config file incompatible (requires version %d)", 3));
            }
            return config;
        }
        catch (Exception e) {
            FactionsMod.LOGGER.error("An error occurred reading the factions config file", (Throwable)e);
            return new Config();
        }
    }

    public static class DisplayConfig {
        @SerializedName(value="factionNameMaxLength")
        public int NAME_MAX_LENGTH = -1;
        @SerializedName(value="changeChat")
        public boolean MODIFY_CHAT = true;
        @SerializedName(value="tabMenu")
        public boolean TAB_MENU = true;
        @SerializedName(value="nameBlackList")
        public List<String> NAME_BLACKLIST = List.of("wilderness", "factionless", "\u0431\u0435\u0437 \u0444\u0440\u0430\u043a\u0446\u0438\u0438");
        @SerializedName(value="powerMessage")
        public boolean POWER_MESSAGE = true;
    }

    public static class RelationshipConfig {
        @SerializedName(value="allyOverridesPermissions")
        public boolean ALLY_OVERRIDES_PERMISSIONS = true;
        @SerializedName(value="defaultGuestPermissions")
        public List<Relationship.Permissions> DEFAULT_GUEST_PERMISSIONS = List.of(Relationship.Permissions.USE_BLOCKS, Relationship.Permissions.USE_ENTITIES);
    }

    public static class Deserializer<T>
    implements JsonDeserializer<T> {
        final Class<T> clazz;

        public Deserializer(Class<T> clazz) {
            this.clazz = clazz;
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject() && !json.getAsBoolean()) {
                return null;
            }
            return (T)new Gson().fromJson(json, this.clazz);
        }
    }
}

