/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.core;

import io.icker.factions.FactionsMod;
import io.icker.factions.api.events.ClaimEvents;
import io.icker.factions.api.events.FactionEvents;
import io.icker.factions.api.events.PlayerEvents;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.Home;
import io.icker.factions.api.persistents.User;
import io.icker.factions.util.Message;
import io.icker.factions.util.WorldUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3908;
import net.minecraft.class_747;
import net.minecraft.server.MinecraftServer;

public class FactionsManager {
    public static class_3324 playerManager;

    public static void register() {
        ServerLifecycleEvents.SERVER_STARTED.register(FactionsManager::serverStarted);
        FactionEvents.MODIFY.register(FactionsManager::factionModified);
        FactionEvents.MEMBER_JOIN.register(FactionsManager::memberChange);
        FactionEvents.MEMBER_LEAVE.register(FactionsManager::memberChange);
        PlayerEvents.ON_KILLED_BY_PLAYER.register(FactionsManager::playerDeath);
        PlayerEvents.ON_POWER_TICK.register(FactionsManager::powerTick);
        PlayerEvents.OPEN_SAFE.register(FactionsManager::openSafe);
        if (FactionsMod.CONFIG.HOME != null && FactionsMod.CONFIG.HOME.CLAIM_ONLY) {
            ClaimEvents.REMOVE.register((x, z, level, faction) -> {
                Home home = faction.getHome();
                if (home == null || !Objects.equals(home.level, level)) {
                    return;
                }
                class_2338 homePos = class_2338.method_49637((double)home.x, (double)home.y, (double)home.z);
                class_3218 world = WorldUtils.getWorld(home.level);
                class_1923 homeChunkPos = world.method_22350(homePos).method_12004();
                if (homeChunkPos.field_9181 == x && homeChunkPos.field_9180 == z) {
                    faction.setHome(null);
                }
            });
        }
    }

    private static void serverStarted(MinecraftServer server) {
        playerManager = server.method_3760();
        Message.manager = server.method_3760();
    }

    private static void factionModified(Faction faction) {
        class_3222[] players = (class_3222[])faction.getUsers().stream().map(user -> playerManager.method_14602(user.getID())).filter(player -> player != null).toArray(class_3222[]::new);
        FactionsManager.updatePlayerList(players);
    }

    private static void memberChange(Faction faction, User user) {
        class_3222 player = playerManager.method_14602(user.getID());
        if (player != null) {
            FactionsManager.updatePlayerList(player);
        }
    }

    private static void playerDeath(class_3222 player, class_1282 source) {
        User member = User.get(player.method_5667());
        if (!member.isInFaction()) {
            return;
        }
        Faction faction = member.getFaction();
        int adjusted = faction.adjustPower(-FactionsMod.CONFIG.POWER.DEATH_PENALTY);
        new Message(class_2561.method_43469((String)"factions.events.lose_power_by_death", (Object[])new Object[]{player.method_5477().getString(), adjusted})).send(faction);
    }

    private static void powerTick(class_3222 player) {
        User member = User.get(player.method_5667());
        if (!member.isInFaction()) {
            return;
        }
        Faction faction = member.getFaction();
        int adjusted = faction.adjustPower(FactionsMod.CONFIG.POWER.POWER_TICKS.REWARD);
        if (adjusted != 0 && FactionsMod.CONFIG.DISPLAY.POWER_MESSAGE) {
            new Message(class_2561.method_43469((String)"factions.events.get_power_by_tick", (Object[])new Object[]{player.method_5477().getString(), adjusted})).send(faction);
        }
    }

    private static void updatePlayerList(class_3222 ... players) {
        playerManager.method_14581((class_2596)new class_2703(EnumSet.of(class_2703.class_5893.field_29139), List.of(players)));
    }

    private static class_1269 openSafe(class_1657 player, Faction faction) {
        User user = User.get(player.method_5667());
        if (!user.isInFaction()) {
            if (FactionsMod.CONFIG.SAFE != null && FactionsMod.CONFIG.SAFE.ENDER_CHEST) {
                new Message(class_2561.method_43471((String)"factions.events.no_enderchests_without_faction")).fail().send(player, false);
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        }
        player.method_17355((class_3908)new class_747((syncId, inventory, p) -> {
            if (FactionsMod.CONFIG.SAFE.DOUBLE) {
                return class_1707.method_19247((int)syncId, (class_1661)inventory, (class_1263)faction.getSafe());
            }
            return class_1707.method_19245((int)syncId, (class_1661)inventory, (class_1263)faction.getSafe());
        }, (class_2561)class_2561.method_43469((String)"factions.gui.safe.title", (Object[])new Object[]{faction.getName()})));
        return class_1269.field_5812;
    }
}

