/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.database;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.icker.factions.FactionsMod;
import io.icker.factions.api.persistents.Relationship;
import io.icker.factions.api.persistents.User;
import io.icker.factions.util.WorldUtils;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_4844;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.apache.commons.lang3.ArrayUtils;

public class SerializerRegistry {
    private static final HashMap<Class<?>, Serializer<?, ? extends class_2520>> registry = new HashMap();

    public static boolean contains(Class<?> clazz) {
        return registry.containsKey(clazz);
    }

    public static <T> class_2520 toNbtElement(Class<T> clazz, T value) {
        return registry.get(clazz).serialize(value);
    }

    public static <T> T fromNbtElement(Class<T> clazz, class_2520 value) {
        return (T)registry.get(clazz).deserialize(value);
    }

    private static <T extends Enum<T>> Serializer<T, class_2519> createEnumSerializer(Class<T> clazz) {
        return new Serializer<Enum, class_2519>(val -> class_2519.method_23256((String)val.toString()), el -> Enum.valueOf(clazz, el.method_68658().orElse("")));
    }

    private static Serializer<class_1277, class_2499> createInventorySerializer(int size) {
        return new Serializer<class_1277, class_2499>(val -> {
            class_8942.class_11340 reporter = new class_8942.class_11340(FactionsMod.LOGGER);
            class_11362 view = class_11362.method_71459((class_8942)reporter, (class_7225.class_7874)WorldUtils.getWorld("minecraft:overworld").method_30349());
            class_11372.class_11373 appender = view.method_71467("Data", InventoryItem.CODEC);
            for (int i = 0; i < val.method_5439(); ++i) {
                class_1799 itemStack = val.method_5438(i);
                if (itemStack.method_7960()) continue;
                appender.method_71484((Object)new InventoryItem(i, itemStack));
            }
            reporter.close();
            return (class_2499)view.method_71475().method_10554("Data").get();
        }, el -> {
            class_2487 compound = new class_2487();
            compound.method_10566("Data", (class_2520)el);
            class_8942.class_11340 reporter = new class_8942.class_11340(FactionsMod.LOGGER);
            class_11368 view = class_11352.method_71417((class_8942)reporter, (class_7225.class_7874)WorldUtils.getWorld("minecraft:overworld").method_30349(), (class_2487)compound);
            class_1277 inventory = new class_1277(size);
            for (int i = 0; i < size; ++i) {
                inventory.method_5447(i, class_1799.field_8037);
            }
            class_11368.class_11369 list_view = view.method_71437("Data", InventoryItem.CODEC);
            for (InventoryItem item : list_view) {
                inventory.method_5447(item.slot(), item.stack());
            }
            reporter.close();
            return inventory;
        });
    }

    static {
        registry.put(Byte.TYPE, new Serializer<Byte, class_2481>(val -> class_2481.method_23233((byte)val), el -> el.method_10698()));
        registry.put(Short.TYPE, new Serializer<Short, class_2516>(val -> class_2516.method_23254((short)val), el -> el.method_10696()));
        registry.put(Integer.TYPE, new Serializer<Integer, class_2497>(val -> class_2497.method_23247((int)val), el -> el.method_10701()));
        registry.put(Long.TYPE, new Serializer<Long, class_2503>(val -> class_2503.method_23251((long)val), el -> el.method_10699()));
        registry.put(Float.TYPE, new Serializer<Float, class_2494>(val -> class_2494.method_23244((float)val.floatValue()), el -> Float.valueOf(el.method_10700())));
        registry.put(Double.TYPE, new Serializer<Double, class_2489>(val -> class_2489.method_23241((double)val), el -> el.method_10697()));
        registry.put(Boolean.TYPE, new Serializer<Boolean, class_2481>(val -> class_2481.method_23234((boolean)val), el -> el.method_10698() != 0));
        registry.put(byte[].class, new Serializer<Byte[], class_2479>(val -> new class_2479(ArrayUtils.toPrimitive((Byte[])val)), el -> ArrayUtils.toObject((byte[])el.method_10521())));
        registry.put(int[].class, new Serializer<Integer[], class_2495>(val -> new class_2495(ArrayUtils.toPrimitive((Integer[])val)), el -> ArrayUtils.toObject((int[])el.method_10588())));
        registry.put(long[].class, new Serializer<Long[], class_2501>(val -> new class_2501(ArrayUtils.toPrimitive((Long[])val)), el -> ArrayUtils.toObject((long[])el.method_10615())));
        registry.put(String.class, new Serializer<String, class_2519>(val -> class_2519.method_23256((String)val), el -> el.method_68658().orElse("")));
        registry.put(UUID.class, new Serializer<UUID, class_2495>(val -> new class_2495(class_4844.method_26275((UUID)val)), el -> class_4844.method_26276((int[])el.method_10588())));
        registry.put(class_1277.class, SerializerRegistry.createInventorySerializer(54));
        registry.put(User.ChatMode.class, SerializerRegistry.createEnumSerializer(User.ChatMode.class));
        registry.put(User.SoundMode.class, SerializerRegistry.createEnumSerializer(User.SoundMode.class));
        registry.put(User.Rank.class, SerializerRegistry.createEnumSerializer(User.Rank.class));
        registry.put(Relationship.Status.class, SerializerRegistry.createEnumSerializer(Relationship.Status.class));
        registry.put(Relationship.Permissions.class, SerializerRegistry.createEnumSerializer(Relationship.Permissions.class));
    }

    private static class Serializer<T, E extends class_2520> {
        private final Function<T, E> serializer;
        private final Function<E, T> deserializer;

        public Serializer(Function<T, E> serializer, Function<E, T> deserializer) {
            this.serializer = serializer;
            this.deserializer = deserializer;
        }

        public class_2520 serialize(Object value) {
            return (class_2520)this.serializer.apply(value);
        }

        public T deserialize(class_2520 value) {
            return this.deserializer.apply(value);
        }
    }

    public record InventoryItem(int slot, class_1799 stack) {
        public static final Codec<InventoryItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_49012.fieldOf("Slot").orElse((Object)0).forGetter(InventoryItem::slot), (App)class_1799.field_55709.fieldOf("Data").forGetter(InventoryItem::stack)).apply((Applicative)instance, InventoryItem::new));
    }
}

