/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.ui;

import com.mojang.authlib.GameProfile;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.User;
import io.icker.factions.command.RankCommand;
import io.icker.factions.ui.PagedGui;
import io.icker.factions.util.Command;
import io.icker.factions.util.GuiInteract;
import io.icker.factions.util.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_11755;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.server.translations.api.Localization;

public class MemberGui
extends PagedGui {
    Faction faction;
    int size;
    class_11755 resolver;
    User user;
    List<User> members;

    public MemberGui(class_3222 player, Faction faction, @Nullable Runnable closeCallback) {
        super(player, closeCallback);
        this.faction = faction;
        this.resolver = player.method_51469().method_8503().method_73550().comp_4624();
        this.user = User.get(player.method_5667());
        this.members = new ArrayList<User>(faction.getUsers());
        if (faction.equals(this.user.getFaction())) {
            this.members.remove(this.user);
            this.members.addFirst(this.user);
        }
        this.size = this.members.size();
        this.setTitle((class_2561)class_2561.method_43469((String)"factions.gui.members.title", (Object[])new Object[]{class_2561.method_43470((String)(String.valueOf(faction.getColor()) + faction.getName())), this.size}));
        this.updateDisplay();
        this.open();
    }

    @Override
    protected int getPageAmount() {
        return this.size / 36;
    }

    @Override
    protected PagedGui.DisplayElement getElement(int id) {
        if (this.size > id) {
            User targetUser = this.members.get(id);
            GameProfile unknownPlayer = new GameProfile(UUID.randomUUID(), Localization.raw((String)"factions.gui.generic.unknown_player", (class_3222)this.player));
            GameProfile profile = this.resolver.method_73290(targetUser.getID()).orElse(unknownPlayer);
            GuiElementBuilder icon = new GuiElementBuilder(class_1802.field_8575);
            icon.setProfile(profile);
            icon.setName((class_2561)class_2561.method_43470((String)profile.name()));
            if (profile.equals((Object)unknownPlayer)) {
                List<class_5250> lore = List.of(class_2561.method_43471((String)"factions.gui.members.entry.unknown_player").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1080)));
                icon.setLore(lore);
                icon.setProfileSkinTexture("ewogICJ0aW1lc3RhbXAiIDogMTczNDIzMjI0OTU3OSwKICAicHJvZmlsZUlkIiA6ICI1ZjU5NmViY2JlOTQ0NmQxYmI0M2JlNGYzZjRiOGJlNSIsCiAgInByb2ZpbGVOYW1lIiA6ICJUZWlsMHNzIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2FlNzgzZmMwNmRlOTRiYTU4YzYyMTc5MGNmMjMxYmZjNThhNGZhMGM1YjIwODdjN2IwOTY1NGI1YWM5YTc5YTIiLAogICAgICAibWV0YWRhdGEiIDogewogICAgICAgICJtb2RlbCIgOiAic2xpbSIKICAgICAgfQogICAgfQogIH0KfQ==");
                return PagedGui.DisplayElement.of(icon);
            }
            ArrayList<class_5250> lore = new ArrayList<class_5250>(List.of(class_2561.method_43469((String)"factions.gui.members.entry.info.rank", (Object[])new Object[]{class_2561.method_43471((String)("factions.gui.members.entry.info.rank." + targetUser.getRankName())).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1060))}).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1080))));
            if (!profile.id().equals(this.player.method_5667()) && Command.Requires.isLeader().test(this.player.method_64396()) && Command.Requires.hasPerms("factions.rank.promote", 0).test(this.player.method_64396()) && this.faction.equals(this.user.getFaction())) {
                lore.add(class_2561.method_43471((String)"factions.gui.members.entry.manage.promote").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1077)));
                lore.add(class_2561.method_43471((String)"factions.gui.members.entry.manage.demote").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1079)));
                lore.add(class_2561.method_43471((String)"factions.gui.members.entry.manage.kick").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1079)));
                class_3222 targetPlayer = this.player.method_51469().method_8503().method_3760().method_14602(targetUser.getID());
                icon.setCallback((index, clickType, actionType) -> {
                    GuiInteract.playClickSound(this.player);
                    if (clickType == ClickType.MOUSE_LEFT) {
                        try {
                            RankCommand.execPromote(targetUser, this.player);
                            new Message(class_2561.method_43469((String)"factions.gui.members.entry.manage.promote.result", (Object[])new Object[]{profile.name(), class_2561.method_43471((String)("factions.gui.members.entry.info.rank." + targetUser.getRankName()))})).prependFaction(this.faction).send((class_1657)this.player, false);
                        }
                        catch (Exception e) {
                            new Message(e.getMessage()).format(class_124.field_1061).send((class_1657)this.player, false);
                            return;
                        }
                    }
                    if (clickType == ClickType.MOUSE_RIGHT) {
                        try {
                            RankCommand.execDemote(targetUser, this.player);
                            new Message(class_2561.method_43469((String)"factions.gui.members.entry.manage.demote.result", (Object[])new Object[]{profile.name(), class_2561.method_43471((String)("factions.gui.members.entry.info.rank." + targetUser.getRankName()))})).prependFaction(this.faction).send((class_1657)this.player, false);
                        }
                        catch (Exception e) {
                            new Message(e.getMessage()).format(class_124.field_1061).send((class_1657)this.player, false);
                            return;
                        }
                    }
                    if (clickType == ClickType.DROP) {
                        SimpleGui gui = new SimpleGui(class_3917.field_17337, this.player, false);
                        for (int i = 0; i < 5; ++i) {
                            gui.setSlot(i, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8736).hideTooltip());
                        }
                        gui.setTitle((class_2561)class_2561.method_43471((String)"factions.gui.members.entry.manage.kick.confirm.title"));
                        gui.setSlot(1, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8777).setName((class_2561)class_2561.method_43469((String)"factions.gui.members.entry.manage.kick.confirm.yes", (Object[])new Object[]{profile.name()}).method_27692(class_124.field_1060)).setCallback((index2, clickType2, actionType2) -> {
                            if (this.user.rank == User.Rank.LEADER && (targetUser.rank == User.Rank.LEADER || targetUser.rank == User.Rank.OWNER)) {
                                new Message(class_2561.method_43471((String)"factions.command.kick.fail.high_rank")).format(class_124.field_1061).send((class_1657)this.player, false);
                                return;
                            }
                            GuiInteract.playClickSound(this.player);
                            targetUser.leaveFaction();
                            new Message(class_2561.method_43469((String)"factions.gui.members.entry.manage.kick.result.actor", (Object[])new Object[]{profile.name()})).send((class_1657)this.player, false);
                            if (targetPlayer != null) {
                                new Message(class_2561.method_43469((String)"factions.gui.members.entry.manage.kick.result.subject", (Object[])new Object[]{this.player.method_5477().getString()})).send((class_1657)targetPlayer, false);
                            }
                            this.open();
                        }));
                        gui.setSlot(3, new GuiElementBuilder(class_1802.field_8615).setName((class_2561)class_2561.method_43471((String)"factions.gui.members.entry.manage.kick.confirm.no").method_27692(class_124.field_1061)).setCallback(() -> {
                            GuiInteract.playClickSound(this.player);
                            this.open();
                        }));
                        gui.open();
                    }
                    lore.removeFirst();
                    lore.addFirst(class_2561.method_43469((String)"factions.gui.members.entry.info.rank", (Object[])new Object[]{class_2561.method_43471((String)("factions.gui.members.entry.info.rank." + targetUser.getRankName())).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1060))}).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1080)));
                    icon.setLore(lore);
                });
            }
            icon.setLore(lore);
            return PagedGui.DisplayElement.of(icon);
        }
        return PagedGui.DisplayElement.empty();
    }
}

