/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.util;

import com.flowpowered.math.vector.Vector2i;
import io.icker.factions.FactionsMod;
import io.icker.factions.api.events.ClaimEvents;
import io.icker.factions.api.events.FactionEvents;
import io.icker.factions.api.persistents.Claim;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.Home;
import io.icker.factions.util.ClaimGrouper;
import io.icker.factions.util.WorldUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.GenericMarker;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;
import org.dynmap.markers.PolyLineMarker;

public class DynmapWrapper {
    private DynmapCommonAPI api;
    private MarkerAPI markerApi;
    private MarkerSet markerSet;
    private boolean loadWhenReady = false;

    public DynmapWrapper() {
        DynmapCommonAPIListener.register((DynmapCommonAPIListener)new DynmapCommonAPIListener(){

            public void apiEnabled(DynmapCommonAPI dCAPI) {
                DynmapWrapper.this.api = dCAPI;
                DynmapWrapper.this.markerApi = DynmapWrapper.this.api.getMarkerAPI();
                DynmapWrapper.this.markerSet = DynmapWrapper.this.markerApi.getMarkerSet("dynmap-factions");
                if (DynmapWrapper.this.markerSet == null) {
                    DynmapWrapper.this.markerSet = DynmapWrapper.this.markerApi.createMarkerSet("dynmap-factions", "The Dynmap Factions integration", null, true);
                }
                DynmapWrapper.this.markerSet.getMarkers().forEach(GenericMarker::deleteMarker);
                DynmapWrapper.this.generateMarkers();
            }
        });
        ClaimEvents.ADD.register(claim -> this.generateMarkers());
        ClaimEvents.REMOVE.register((x, z, level, faction) -> this.generateMarkers());
        WorldUtils.ON_READY.register(() -> {
            if (this.loadWhenReady) {
                this.loadWhenReady = false;
                this.generateMarkers();
            }
        });
        FactionEvents.SET_HOME.register(this::setHome);
        FactionEvents.MODIFY.register(faction -> this.updateFaction(faction));
        FactionEvents.MEMBER_JOIN.register((faction, user) -> this.updateFaction(faction));
        FactionEvents.MEMBER_LEAVE.register((faction, user) -> this.updateFaction(faction));
        FactionEvents.POWER_CHANGE.register((faction, oldPower) -> this.updateFaction(faction));
        FactionEvents.DISBAND.register(faction -> this.generateMarkers());
    }

    private void generateMarkers() {
        if (!WorldUtils.isReady() || !WorldUtils.hasWorlds()) {
            this.loadWhenReady = true;
            FactionsMod.LOGGER.info("Server hasn't loaded, postponing dynmap marker loading");
            return;
        }
        for (PolyLineMarker marker : this.markerSet.getPolyLineMarkers()) {
            marker.deleteMarker();
        }
        for (PolyLineMarker marker : this.markerSet.getAreaMarkers()) {
            marker.deleteMarker();
        }
        for (Faction faction : Faction.all()) {
            Home home = faction.getHome();
            if (home != null) {
                this.setHome(faction, home);
            }
            String info = this.getInfo(faction);
            for (Claim claim : faction.getClaims()) {
                class_1923 pos = new class_1923(claim.x, claim.z);
                AreaMarker marker = this.markerSet.createAreaMarker(claim.getKey(), info, true, this.dimensionTagToID(claim.level), new double[]{pos.method_8326(), pos.method_8327() + 1}, new double[]{pos.method_8328(), pos.method_8329() + 1}, true);
                if (marker == null) continue;
                marker.setFillStyle(marker.getFillOpacity(), faction.getColor().method_532().intValue());
                marker.setLineStyle(0, 0.0, 0);
            }
            for (Map.Entry entry : ClaimGrouper.separateClaimsByLevel(faction).entrySet()) {
                String level = (String)entry.getKey();
                for (Map<Vector2i, Vector2i[]> group : ClaimGrouper.convertClaimsToLineSegmentGroupsWithoutHoles((Set)entry.getValue())) {
                    List<List<Vector2i>> outlines = ClaimGrouper.convertLineSegmentsToOutlines(group);
                    if (outlines.size() > 1) {
                        FactionsMod.LOGGER.error("The claim chunking algorithm used for dynmap has failed, please report this asap.");
                    }
                    outlines.getFirst().add(outlines.getFirst().getFirst());
                    double[] x_coords = outlines.getFirst().stream().mapToDouble(point -> point.getX()).toArray();
                    double[] z_coords = outlines.getFirst().stream().mapToDouble(point -> point.getY()).toArray();
                    double[] y_coords = outlines.getFirst().stream().mapToDouble(point -> 320.0).toArray();
                    PolyLineMarker marker = this.markerSet.createPolyLineMarker(UUID.randomUUID().toString(), "", false, this.dimensionTagToID(level), x_coords, y_coords, z_coords, true);
                    if (marker == null) continue;
                    marker.setLineStyle(marker.getLineWeight(), marker.getLineOpacity(), faction.getColor().method_532().intValue());
                }
            }
        }
    }

    private void updateFaction(Faction faction) {
        String info = this.getInfo(faction);
        for (Claim claim : faction.getClaims()) {
            AreaMarker marker = this.markerSet.findAreaMarker(claim.getKey());
            marker.setFillStyle(marker.getFillOpacity(), faction.getColor().method_532().intValue());
            marker.setLineStyle(marker.getLineWeight(), marker.getLineOpacity(), faction.getColor().method_532().intValue());
            marker.setDescription(info);
        }
    }

    private void setHome(Faction faction, Home home) {
        Marker marker = this.markerSet.findMarker(faction.getID().toString() + "-home");
        if (home == null && marker != null) {
            marker.deleteMarker();
            return;
        }
        if (marker == null) {
            this.markerSet.createMarker(faction.getID().toString() + "-home", faction.getName() + "'s Home", this.dimensionTagToID(home.level), home.x, home.y, home.z, null, true);
        } else {
            marker.setLocation(this.dimensionTagToID(home.level), home.x, home.y, home.z);
        }
    }

    public String getWorldName(class_1937 w) {
        class_5321 rk = w.method_27983();
        if (rk == class_1937.field_25179) {
            return w.method_8503().method_27728().method_150();
        }
        if (rk == class_1937.field_25181) {
            return "DIM1";
        }
        if (rk == class_1937.field_25180) {
            return "DIM-1";
        }
        return rk.method_29177().method_12836() + "_" + rk.method_29177().method_12832();
    }

    public String dimensionTagToID(String dimension_id) {
        if (!WorldUtils.isReady()) {
            FactionsMod.LOGGER.warn("Server object has not been initialized please run the dynmap reload command");
            return dimension_id;
        }
        class_3218 world = WorldUtils.getWorld(dimension_id);
        if (world == null) {
            FactionsMod.LOGGER.error(String.format("Unable to find dimension id: %s", dimension_id));
            return dimension_id;
        }
        return this.getWorldName((class_1937)world);
    }

    private String getInfo(Faction faction) {
        return "Name: " + faction.getName() + "<br>Description: " + faction.getDescription() + "<br>Power: " + faction.getPower() + "<br>Number of members: " + faction.getUsers().size();
    }

    public void reloadAll() {
        this.markerSet.deleteMarkerSet();
        this.markerSet = this.markerApi.createMarkerSet("dynmap-factions", "The Dynmap Factions integration", null, true);
        this.generateMarkers();
    }
}

