/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.util;

import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import io.icker.factions.FactionsMod;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.User;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import xyz.nucleoid.server.translations.api.Localization;
import xyz.nucleoid.server.translations.api.language.ServerLanguage;

public class PlaceholdersWrapper {
    private static final class_2561 UNFORMATTED_NULL = class_2561.method_43471((String)"factions.papi.factionless");
    private static final class_2561 FORMATTED_NULL = UNFORMATTED_NULL.method_27661().method_27692(class_124.field_1063);

    private static void register(String identifier, Function<User, class_2561> handler) {
        Placeholders.register((class_2960)class_2960.method_60655((String)"factions", (String)identifier), (ctx, argument) -> {
            if (!ctx.hasPlayer()) {
                return PlaceholderResult.invalid((String)Localization.raw((String)"argument.entity.notfound.player", (ServerLanguage)ServerLanguage.getLanguage((String)FactionsMod.CONFIG.LANGUAGE)));
            }
            User member = User.get(ctx.player().method_5667());
            return PlaceholderResult.value((class_2561)((class_2561)handler.apply(member)));
        });
    }

    public static void init() {
        PlaceholdersWrapper.register("name", member -> {
            Faction faction = member.getFaction();
            if (faction == null) {
                return FORMATTED_NULL;
            }
            return class_2561.method_43470((String)faction.getName()).method_27692(member.getFaction().getColor());
        });
        PlaceholdersWrapper.register("colorless_name", member -> {
            Faction faction = member.getFaction();
            if (faction == null) {
                return FORMATTED_NULL;
            }
            return class_2561.method_30163((String)faction.getName());
        });
        PlaceholdersWrapper.register("chat", member -> {
            if (member.chat == User.ChatMode.GLOBAL || !member.isInFaction()) {
                return class_2561.method_43471((String)"factions.papi.chat.global");
            }
            return class_2561.method_43471((String)"factions.papi.chat.faction");
        });
        PlaceholdersWrapper.register("rank", member -> {
            if (!member.isInFaction()) {
                return FORMATTED_NULL;
            }
            return class_2561.method_30163((String)member.getRankName());
        });
        PlaceholdersWrapper.register("color", member -> {
            if (!member.isInFaction()) {
                return class_2561.method_30163((String)"reset");
            }
            return class_2561.method_30163((String)member.getFaction().getColor().method_537());
        });
        PlaceholdersWrapper.register("description", member -> {
            Faction faction = member.getFaction();
            if (faction == null) {
                return FORMATTED_NULL;
            }
            return class_2561.method_30163((String)faction.getDescription());
        });
        PlaceholdersWrapper.register("state", member -> {
            Faction faction = member.getFaction();
            if (faction == null) {
                return UNFORMATTED_NULL;
            }
            return class_2561.method_30163((String)String.valueOf(faction.isOpen()));
        });
        PlaceholdersWrapper.register("power", member -> {
            Faction faction = member.getFaction();
            if (faction == null) {
                return UNFORMATTED_NULL;
            }
            return class_2561.method_30163((String)String.valueOf(faction.getPower()));
        });
        PlaceholdersWrapper.register("power_formatted", member -> {
            Faction faction = member.getFaction();
            if (faction == null) {
                return FORMATTED_NULL;
            }
            int red = PlaceholdersWrapper.mapBoundRange(faction.calculateMaxPower(), 0, 170, 255, faction.getPower());
            int green = PlaceholdersWrapper.mapBoundRange(0, faction.calculateMaxPower(), 170, 255, faction.getPower());
            return class_2561.method_43470((String)String.valueOf(faction.getPower())).method_10862(class_2583.field_24360.method_36139(PlaceholdersWrapper.rgbToInt(red, green, 170)));
        });
        PlaceholdersWrapper.register("max_power", member -> {
            Faction faction = member.getFaction();
            if (faction == null) {
                return UNFORMATTED_NULL;
            }
            return class_2561.method_30163((String)String.valueOf(faction.calculateMaxPower()));
        });
        PlaceholdersWrapper.register("player_power", member -> class_2561.method_30163((String)String.valueOf(FactionsMod.CONFIG.POWER.MEMBER)));
        PlaceholdersWrapper.register("required_power", member -> {
            Faction faction = member.getFaction();
            if (faction == null) {
                return UNFORMATTED_NULL;
            }
            return class_2561.method_30163((String)String.valueOf(faction.getClaims().size() * FactionsMod.CONFIG.POWER.CLAIM_WEIGHT));
        });
        PlaceholdersWrapper.register("required_power_formatted", member -> {
            Faction faction = member.getFaction();
            if (faction == null) {
                return FORMATTED_NULL;
            }
            int reqPower = faction.getClaims().size() * FactionsMod.CONFIG.POWER.CLAIM_WEIGHT;
            int red = PlaceholdersWrapper.mapBoundRange(0, faction.getPower(), 85, 255, reqPower);
            return class_2561.method_43470((String)String.valueOf(reqPower)).method_10862(class_2583.field_24360.method_36139(PlaceholdersWrapper.rgbToInt(red, 85, 85)));
        });
    }

    private static int rgbToInt(int red, int green, int blue) {
        return red & 0xFF0000 | green & 0xFF00 | blue & 0xFF;
    }

    private static int mapBoundRange(int from_min, int from_max, int to_min, int to_max, int value) {
        return Math.min(to_max, Math.max(to_min, to_min + (value - from_min) * (to_max - to_min) / (from_max - from_min)));
    }
}

