/*
 * Decompiled with CFR 0.152.
 */
package io.icker.factions.util;

import com.flowpowered.math.vector.Vector2i;
import io.icker.factions.api.events.ClaimEvents;
import io.icker.factions.api.events.FactionEvents;
import io.icker.factions.api.persistents.Faction;
import io.icker.factions.api.persistents.Home;
import io.icker.factions.util.ClaimGrouper;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.SimpleLayerProvider;
import xyz.jpenilla.squaremap.api.Squaremap;
import xyz.jpenilla.squaremap.api.SquaremapProvider;
import xyz.jpenilla.squaremap.api.WorldIdentifier;
import xyz.jpenilla.squaremap.api.marker.Icon;
import xyz.jpenilla.squaremap.api.marker.Marker;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;

public class SquareMapWrapper {
    private HashMap<String, SimpleLayerProvider> layers = new HashMap();
    private Squaremap api;

    public SquareMapWrapper() {
        ClaimEvents.ADD.register(claim -> this.generateMarkers());
        ClaimEvents.REMOVE.register((x, z, level, faction) -> this.generateMarkers());
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.api = SquaremapProvider.get();
            this.generateMarkers();
        });
        FactionEvents.SET_HOME.register(this::setHome);
        FactionEvents.MODIFY.register(faction -> this.generateMarkers());
        FactionEvents.MEMBER_JOIN.register((faction, user) -> this.generateMarkers());
        FactionEvents.MEMBER_LEAVE.register((faction, user) -> this.generateMarkers());
        FactionEvents.POWER_CHANGE.register((faction, oldPower) -> this.generateMarkers());
        FactionEvents.DISBAND.register(faction -> this.generateMarkers());
    }

    private void generateMarkers() {
        for (SimpleLayerProvider layer : this.layers.values()) {
            for (Key id : layer.registeredMarkers().keySet()) {
                layer.removeMarker(id);
            }
        }
        for (Faction faction : Faction.all()) {
            Home home = faction.getHome();
            if (home != null) {
                this.setHome(faction, home);
            }
            String info = this.getInfo(faction);
            for (Map.Entry<String, Set<Vector2i>> entry : ClaimGrouper.separateClaimsByLevel(faction).entrySet()) {
                String level = entry.getKey();
                for (Map<Vector2i, Vector2i[]> group : ClaimGrouper.convertClaimsToLineSegmentGroups(entry.getValue())) {
                    List<List<Vector2i>> outlines = ClaimGrouper.convertLineSegmentsToOutlines(group);
                    List points = outlines.stream().map(hole -> hole.stream().map(point -> Point.of((double)point.getX(), (double)point.getY())).collect(Collectors.toList())).collect(Collectors.toList());
                    SimpleLayerProvider layer = this.layers.get(level);
                    if (layer == null) {
                        layer = SimpleLayerProvider.builder((String)("factions-" + level)).showControls(true).build();
                        MapWorld world = this.api.getWorldIfEnabled(WorldIdentifier.parse((String)level)).orElse(null);
                        if (world != null) {
                            world.layerRegistry().register(Key.of((String)("factions-" + level.replace(':', '-'))), (Object)layer);
                        }
                        this.layers.put(level, layer);
                    }
                    Marker marker = Marker.polygon((List)((List)points.removeFirst()), points).markerOptions(MarkerOptions.builder().fillColor(new Color(faction.getColor().method_532())).strokeColor(new Color(faction.getColor().method_532())).hoverTooltip(faction.getName()).clickTooltip(info));
                    layer.addMarker(Key.of((String)UUID.randomUUID().toString()), marker);
                }
            }
        }
    }

    private void setHome(Faction faction, Home home) {
        if (home == null) {
            for (Map.Entry<String, SimpleLayerProvider> entry : this.layers.entrySet()) {
                entry.getValue().removeMarker(Key.of((String)(faction.getID().toString() + "-home")));
            }
            return;
        }
        SimpleLayerProvider layer = this.layers.get(home.level);
        if (layer == null) {
            layer = SimpleLayerProvider.builder((String)("factions-" + home.level)).showControls(true).build();
            MapWorld world = this.api.getWorldIfEnabled(WorldIdentifier.parse((String)home.level)).orElse(null);
            if (world != null) {
                world.layerRegistry().register(Key.of((String)("factions-" + home.level.replace(':', '-'))), (Object)layer);
            }
            this.layers.put(home.level, layer);
        }
        for (Map.Entry<String, SimpleLayerProvider> entry : this.layers.entrySet()) {
            if (entry.getKey().equals(home.level)) continue;
            entry.getValue().removeMarker(Key.of((String)(faction.getID().toString() + "-home")));
        }
        Marker marker = (Marker)layer.registeredMarkers().get(Key.of((String)(faction.getID().toString() + "-home")));
        if (marker == null) {
            Marker homeMarker = Marker.icon((Point)Point.of((double)home.x, (double)home.z), (Key)Key.of((String)"squaremap-spawn_icon"), (int)16).markerOptions(MarkerOptions.builder().clickTooltip(this.getInfo(faction)).hoverTooltip(faction.getName() + "'s Home"));
            layer.addMarker(Key.of((String)(faction.getID().toString() + "-home")), homeMarker);
        } else {
            ((Icon)marker).point(Point.of((double)home.x, (double)home.z));
        }
    }

    private String getInfo(Faction faction) {
        return "Name: " + faction.getName() + "<br>Description: " + faction.getDescription() + "<br>Power: " + faction.getPower() + "<br>Number of members: " + faction.getUsers().size();
    }
}

