/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.atlas.atlascore.command.OptsArgumentUtils;
import net.atlas.atlascore.command.argument.Argument;
import net.atlas.atlascore.util.MapUtils;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public record OptsArgument(Map<String, ArgumentType<?>> arguments) {
    public static final DynamicCommandExceptionType ERROR_INVALID_ARGUMENT = new DynamicCommandExceptionType(object -> class_2561.method_54159((String)"arguments.chosen.argument.invalid", (Object[])new Object[]{object}));

    public OptsArgument(String[] names, ArgumentType<?>[] types) {
        this(MapUtils.buildHashMapFromAlignedArrays(names, types));
    }

    public static OptsArgument namesAndArgumentTypes(String[] names, ArgumentType<?>[] types) {
        return new OptsArgument(names, types);
    }

    public static OptsArgument fromSortedArray(Object ... namesAndTypes) {
        if (namesAndTypes.length % 2 == 1) {
            throw new IllegalStateException("Arguments must have both a name and a type!");
        }
        String[] names = new String[namesAndTypes.length / 2];
        ArgumentType[] types = new ArgumentType[namesAndTypes.length / 2];
        for (int index = 0; index < namesAndTypes.length; index += 2) {
            int finalIndex = index / 2;
            if (namesAndTypes[index + 1] == null) continue;
            names[finalIndex] = (String)namesAndTypes[index];
            types[finalIndex] = (ArgumentType)namesAndTypes[index + 1];
        }
        return new OptsArgument(names, types);
    }

    public static OptsArgument fromMap(Map<String, ArgumentType<?>> arguments) {
        ArrayList toRemove = new ArrayList();
        arguments.forEach((string, type) -> {
            if (type == null) {
                toRemove.add(string);
            }
        });
        toRemove.forEach(arguments::remove);
        return new OptsArgument(arguments);
    }

    public List<Argument<?>> readArguments(CommandContext<?> context, String name) throws CommandSyntaxException {
        return this.readArgumentsRaw(context, (String)context.getArgument(name, String.class));
    }

    public List<Argument<?>> readArgumentsRaw(CommandContext<?> context, String input) throws CommandSyntaxException {
        ArrayList args = new ArrayList();
        for (String realArgument : input.split(" ")) {
            StringReader stringReader = new StringReader(realArgument);
            String argumentName = OptsArgument.readArgumentName(stringReader);
            if (!this.arguments.containsKey(argumentName)) continue;
            stringReader.expect('=');
            ArgumentType<?> type = this.arguments.get(argumentName);
            Argument<?> ret = this.buildArgument(stringReader, context, type, argumentName);
            args.add(ret);
        }
        return args;
    }

    private static String readArgumentName(StringReader stringReader) {
        int i = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != '=' && !Character.isWhitespace(stringReader.peek())) {
            stringReader.skip();
        }
        return stringReader.getString().substring(i, stringReader.getCursor());
    }

    private <S, T> Argument<T> buildArgument(StringReader stringReader, CommandContext<S> commandContext, ArgumentType<T> type, String argumentName) throws CommandSyntaxException {
        Object result = type.parse(stringReader, commandContext.getSource());
        return new Argument<Object>(argumentName, result, result.getClass());
    }

    public <S> CompletableFuture<Suggestions> suggestions(CommandContext<S> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        return this.suggestionsInternal(context, builder, builder.getStart());
    }

    private <S> CompletableFuture<Suggestions> suggestionsInternal(CommandContext<S> context, SuggestionsBuilder builder, int start) {
        List<Object> args;
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        int original = reader.getCursor();
        while (reader.canRead() && !Character.isWhitespace(reader.peek())) {
            reader.skip();
        }
        SuggestionsVisitor visitor = new SuggestionsVisitor();
        try {
            args = this.readArgumentsRaw(context, reader.getString().substring(start, reader.getCursor()));
        }
        catch (CommandSyntaxException ignored) {
            args = Collections.emptyList();
        }
        List finalArgs = args;
        List<String> argumentNames = this.arguments.keySet().stream().filter(string -> {
            AtomicBoolean ret = new AtomicBoolean(true);
            finalArgs.forEach(arg -> ret.set(ret.get() & !arg.name().equals(string)));
            return ret.get();
        }).toList();
        visitor.visitSuggestions(suggestionsBuilder -> class_2172.method_9265((Iterable)argumentNames, (SuggestionsBuilder)builder));
        try {
            if (!argumentNames.isEmpty() && reader.canRead() && Character.isWhitespace(reader.peek())) {
                CompletableFuture<Suggestions> tryInception = this.suggestionsInternal(context, builder.createOffset(reader.getCursor() + 1), start);
                visitor.visitSuggestions(builder1 -> tryInception);
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create();
            }
            reader.setCursor(original);
            this.suggestArgument(visitor, context, reader, argumentNames);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return visitor.resolveSuggestions(builder, reader);
    }

    private <S> void suggestArgument(SuggestionsVisitor visitor, CommandContext<S> context, StringReader reader, List<String> argumentNames) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String argumentName = OptsArgument.readArgumentName(reader);
        if (!argumentNames.contains(argumentName)) {
            reader.setCursor(cursor);
            throw ERROR_INVALID_ARGUMENT.createWithContext((ImmutableStringReader)reader, (Object)argumentName);
        }
        visitor.visitSuggestions(this::suggestSetValue);
        reader.expect('=');
        visitor.visitSuggestions(builder -> this.arguments.get(argumentName).listSuggestions(context, builder));
        reader.expect(' ');
    }

    private CompletableFuture<Suggestions> suggestSetValue(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf('='));
        }
        return suggestionsBuilder.buildFuture();
    }

    static class SuggestionsVisitor {
        private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = OptsArgumentUtils.SUGGEST_NOTHING;

        SuggestionsVisitor() {
        }

        public void visitSuggestions(Function<SuggestionsBuilder, CompletableFuture<Suggestions>> function) {
            this.suggestions = function;
        }

        public CompletableFuture<Suggestions> resolveSuggestions(SuggestionsBuilder suggestionsBuilder, StringReader stringReader) {
            return this.suggestions.apply(suggestionsBuilder.createOffset(stringReader.getCursor()));
        }
    }
}

