/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.common.stats;

import java.util.HashMap;
import java.util.Map;
import mobchampions.MobChampions;
import mobchampions.common.stats.ChampionStats;
import mobchampions.config.ConfigHandler;
import mobchampions.network.MobChampion;
import mobchampions.platform.Services;

public class ChampionStatsManager {
    private static final Map<Integer, ChampionStats> UNCOMMON = new HashMap<Integer, ChampionStats>(10);
    private static final Map<Integer, ChampionStats> RARE = new HashMap<Integer, ChampionStats>(10);
    private static final Map<Integer, ChampionStats> EPIC = new HashMap<Integer, ChampionStats>(10);
    private static final Map<Integer, ChampionStats> LEGENDARY = new HashMap<Integer, ChampionStats>(10);
    private static final ChampionStats uncommonBase = new ChampionStats(0.5f, 2, 0.05f, 0.1f, 0.7f, 0.03f);
    private static final ChampionStats rareBase = new ChampionStats(0.9f, 4, 0.15f, 0.4f, 1.4f, 0.1f);
    private static final ChampionStats epicBase = new ChampionStats(1.8f, 8, 0.3f, 0.7f, 2.2f, 0.5f);
    private static final ChampionStats legendaryBase = new ChampionStats(2.7f, 15, 0.5f, 0.9f, 2.9f, 1.0f);

    public static void init() {
        for (int level = 1; level <= 10; ++level) {
            UNCOMMON.put(level, new ChampionStats(ChampionStatsManager.scaleStat(uncommonBase.getHealthMultiplier(), level), ChampionStatsManager.scaleStat(uncommonBase.getArmorAddition(), level), ChampionStatsManager.scaleStat(uncommonBase.getMovementSpeedMultiplier(), level), ChampionStatsManager.scaleStat(uncommonBase.getAttackDamageMultiplier(), level), ChampionStatsManager.scaleStat(uncommonBase.getArrowDamageMultiplier(), level), ChampionStatsManager.scaleStat(uncommonBase.getKnockbackResistanceAddition(), level)));
            RARE.put(level, new ChampionStats(ChampionStatsManager.scaleStat(rareBase.getHealthMultiplier(), level), ChampionStatsManager.scaleStat(rareBase.getArmorAddition(), level), ChampionStatsManager.scaleStat(rareBase.getMovementSpeedMultiplier(), level), ChampionStatsManager.scaleStat(rareBase.getAttackDamageMultiplier(), level), ChampionStatsManager.scaleStat(rareBase.getArrowDamageMultiplier(), level), ChampionStatsManager.scaleStat(rareBase.getKnockbackResistanceAddition(), level)));
            EPIC.put(level, new ChampionStats(ChampionStatsManager.scaleStat(epicBase.getHealthMultiplier(), level), ChampionStatsManager.scaleStat(epicBase.getArmorAddition(), level), ChampionStatsManager.scaleStat(epicBase.getMovementSpeedMultiplier(), level), ChampionStatsManager.scaleStat(epicBase.getAttackDamageMultiplier(), level), ChampionStatsManager.scaleStat(epicBase.getArrowDamageMultiplier(), level), ChampionStatsManager.scaleStat(epicBase.getKnockbackResistanceAddition(), level)));
            LEGENDARY.put(level, new ChampionStats(ChampionStatsManager.scaleStat(legendaryBase.getHealthMultiplier(), level), ChampionStatsManager.scaleStat(legendaryBase.getArmorAddition(), level), ChampionStatsManager.scaleStat(legendaryBase.getMovementSpeedMultiplier(), level), ChampionStatsManager.scaleStat(legendaryBase.getAttackDamageMultiplier(), level), ChampionStatsManager.scaleStat(legendaryBase.getArrowDamageMultiplier(), level), ChampionStatsManager.scaleStat(legendaryBase.getKnockbackResistanceAddition(), level)));
        }
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            for (Map.Entry<Integer, ChampionStats> entry : UNCOMMON.entrySet()) {
                MobChampions.LOGGER.warn("Uncommon Level {}: {}", (Object)entry.getKey(), (Object)entry.getValue().toString());
            }
            for (Map.Entry<Integer, ChampionStats> entry : RARE.entrySet()) {
                MobChampions.LOGGER.warn("Rare Level {}: {}", (Object)entry.getKey(), (Object)entry.getValue().toString());
            }
            for (Map.Entry<Integer, ChampionStats> entry : EPIC.entrySet()) {
                MobChampions.LOGGER.warn("Epic Level {}: {}", (Object)entry.getKey(), (Object)entry.getValue().toString());
            }
            for (Map.Entry<Integer, ChampionStats> entry : LEGENDARY.entrySet()) {
                MobChampions.LOGGER.warn("Legendary Level {}: {}", (Object)entry.getKey(), (Object)entry.getValue().toString());
            }
        }
    }

    private static float scaleStat(float base, int level) {
        return base / 5.0f * (float)level;
    }

    private static int scaleStat(int base, int level) {
        return (int)Math.ceil((double)base / 5.0 * (double)level);
    }

    public static ChampionStats getStatsForRank(MobChampion.Rank rank) {
        Map<Integer, ChampionStats> statsMap = switch (rank) {
            case MobChampion.Rank.RARE -> RARE;
            case MobChampion.Rank.EPIC -> EPIC;
            case MobChampion.Rank.LEGENDARY -> LEGENDARY;
            default -> UNCOMMON;
        };
        return statsMap.get(ConfigHandler.Common.getDifficultyForRank(rank));
    }
}

