/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.mixin;

import java.util.function.Consumer;
import mobchampions.common.effect.MobChampionsEffects;
import mobchampions.config.ConfigHandler;
import mobchampions.loot.MobChampionsLootTables;
import mobchampions.network.MobChampion;
import mobchampions.platform.Services;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Shadow
    @Nullable
    public abstract class_1657 method_66280();

    public LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"dropFromLootTable(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;ZLnet/minecraft/resources/ResourceKey;Ljava/util/function/Consumer;)V"}, at={@At(value="TAIL")})
    public void mc$dropFromLootTable(class_3218 level, class_1282 damageSource, boolean playerKill, class_5321<class_52> lootTable, Consumer<class_1799> dropConsumer, CallbackInfo ci) {
        class_1657 player = this.method_66280();
        if (!playerKill) {
            return;
        }
        class_1309 livingEntity = (class_1309)this;
        Services.PLATFORM.getMobChampionData(livingEntity).ifPresent(data -> {
            if (data.getEntityId() != -1 && data.getRank() != MobChampion.Rank.COMMON) {
                class_8567 params = this.mobChampions$createEquipmentParams(livingEntity, level, damageSource, player);
                float lootChance = ConfigHandler.Common.getLootDropChance(data.getRank());
                if (lootChance > 0.0f && level.method_8409().method_43057() < lootChance) {
                    class_5321<class_52> weaponLootTableKey = MobChampionsLootTables.getWeaponLootTable(data.getRank());
                    class_5321<class_52> wearableLootTableKey = MobChampionsLootTables.getWearableLootTable(data.getRank());
                    class_5321<class_52> genericLootTableKey = MobChampionsLootTables.getGenericLootTable(data.getRank());
                    class_52 weaponLootTable = level.method_8503().method_58576().method_58295(weaponLootTableKey);
                    class_52 wearableLootTable = level.method_8503().method_58576().method_58295(wearableLootTableKey);
                    class_52 genericLootTable = level.method_8503().method_58576().method_58295(genericLootTableKey);
                    weaponLootTable.method_51878(params).forEach(itemStack -> livingEntity.method_5775(level, itemStack));
                    wearableLootTable.method_51878(params).forEach(itemStack -> {
                        boolean isElytra = itemStack.method_31574(class_1802.field_8833);
                        boolean dropWearable = true;
                        if (isElytra && !ConfigHandler.Common.allowElytraDrops()) {
                            dropWearable = false;
                        }
                        if (dropWearable) {
                            livingEntity.method_5775(level, itemStack);
                        }
                    });
                    genericLootTable.method_51878(params).forEach(itemStack -> livingEntity.method_5775(level, itemStack));
                }
                if (ConfigHandler.Common.fireworksOnDeath() && data.getRank().ordinal() >= ConfigHandler.Common.getFireworksMinimumRank().ordinal()) {
                    Services.PLATFORM.sendLaunchFireworksPacket(livingEntity);
                }
            }
        });
    }

    @Inject(method={"canBeAffected"}, at={@At(value="RETURN")}, cancellable=true)
    private void mobchampions$modifyCanBeAffected(class_1293 effectInstance, CallbackInfoReturnable<Boolean> cir) {
        class_1309 livingEntity = (class_1309)this;
        if (MobChampionsEffects.ALL_CHAMPION_EFFECT_HOLDERS.contains(effectInstance.method_5579())) {
            Services.PLATFORM.getMobChampionData(livingEntity).ifPresent(data -> {
                if (data.getEntityId() != -1 && data.getRank() != MobChampion.Rank.COMMON) {
                    cir.setReturnValue((Object)true);
                } else {
                    cir.setReturnValue((Object)false);
                }
            });
        }
    }

    @Unique
    private class_8567 mobChampions$createEquipmentParams(class_1309 livingEntity, class_3218 level, class_1282 damageSource, class_1657 player) {
        class_8567.class_8568 lootparams$builder = new class_8567.class_8568(level).method_51874(class_181.field_1226, (Object)livingEntity).method_51874(class_181.field_24424, (Object)livingEntity.method_73189()).method_51874(class_181.field_1231, (Object)damageSource).method_51877(class_181.field_1230, (Object)damageSource.method_5529()).method_51877(class_181.field_1227, (Object)damageSource.method_5526());
        if (player != null) {
            lootparams$builder = lootparams$builder.method_51874(class_181.field_1233, (Object)player).method_51871(player.method_7292());
        }
        return lootparams$builder.method_51875(class_173.field_1173);
    }
}

