/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.compat;

import net.atlas.combatify.Combatify;
import net.atlas.combatify.CombatifyClient;
import net.atlas.combatify.config.DualAttackIndicatorStatus;
import net.atlas.combatify.config.ShieldIndicatorStatus;
import net.caffeinemc.mods.sodium.api.config.ConfigEntryPoint;
import net.caffeinemc.mods.sodium.api.config.StorageEventHandler;
import net.caffeinemc.mods.sodium.api.config.structure.ConfigBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionPageBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.PageBuilder;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlValueFormatterImpls;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_4061;
import net.minecraft.class_5244;
import net.minecraft.class_9851;

public class CombatifySodiumConfig
implements ConfigEntryPoint {
    private static final class_2960 COMBATIFY_ICON = class_2960.method_60655((String)"combatify", (String)"textures/gui/config_icon.png");
    private final class_315 vanillaOpts;
    private final StorageEventHandler vanillaStorage;

    public CombatifySodiumConfig() {
        class_310 minecraft = class_310.method_1551();
        this.vanillaOpts = minecraft.field_1690;
        this.vanillaStorage = () -> {
            this.vanillaOpts.method_1640();
            SodiumClientMod.logger().info("Flushed changes to Minecraft configuration");
        };
    }

    public void registerConfigLate(ConfigBuilder configBuilder) {
        this.buildFullConfig(configBuilder);
    }

    private void buildFullConfig(ConfigBuilder builder) {
        builder.registerOwnModOptions().setName("Combatify").setIcon(COMBATIFY_ICON).setColorTheme(builder.createColorTheme().setFullThemeRGB(-15247758, -14449006, -15781288)).addPage((PageBuilder)this.buildGeneralPage(builder));
    }

    private OptionPageBuilder buildGeneralPage(ConfigBuilder builder) {
        OptionPageBuilder generalPage = builder.createOptionPage().setName((class_2561)class_2561.method_43470((String)"Combatify General"));
        generalPage.addOptionGroup(builder.createOptionGroup().addOption((OptionBuilder)builder.createEnumOption(Combatify.id("general.dual_attack_indicator"), DualAttackIndicatorStatus.class).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.dualAttackIndicator")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.dual_attack_indicator.tooltip")).setDefaultValue((Enum)DualAttackIndicatorStatus.OFF).setElementNameProvider(DualAttackIndicatorStatus::caption).setBinding(arg_0 -> CombatifyClient.dualAttackIndicator.method_41748(arg_0), () -> CombatifyClient.dualAttackIndicator.method_41753())).addOption((OptionBuilder)builder.createEnumOption(Combatify.id("general.shield_indicator"), ShieldIndicatorStatus.class).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.shieldIndicator")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.shield_indicator.tooltip")).setDefaultValue((Enum)ShieldIndicatorStatus.OFF).setElementNameProvider(ShieldIndicatorStatus::caption).setBinding(arg_0 -> CombatifyClient.shieldIndicator.method_41748(arg_0), () -> CombatifyClient.shieldIndicator.method_41753())).addOption((OptionBuilder)builder.createEnumOption(Combatify.id("general.projectile_charge_indicator"), class_4061.class).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.projectileChargeIndicator")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.projectile_charge_indicator.tooltip")).setDefaultValue((Enum)class_4061.field_18151).setElementNameProvider(class_4061::method_76522).setBinding(arg_0 -> CombatifyClient.projectileChargeIndicator.method_41748(arg_0), () -> CombatifyClient.projectileChargeIndicator.method_41753())).addOption((OptionBuilder)builder.createEnumOption(Combatify.id("general.spear_charge_indicator"), class_4061.class).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.spearChargeIndicator")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.spear_charge_indicator.tooltip")).setDefaultValue((Enum)class_4061.field_18151).setElementNameProvider(class_4061::method_76522).setBinding(arg_0 -> CombatifyClient.spearChargeIndicator.method_41748(arg_0), () -> CombatifyClient.spearChargeIndicator.method_41753())).addOption((OptionBuilder)builder.createIntegerOption(Combatify.id("general.attack_indicator_max_value")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.attackIndicatorMaxValue")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.attack_indicator_max_value.tooltip")).setDefaultValue(Integer.valueOf(200)).setValueFormatter(ControlValueFormatterImpls.percentage()).setRange(1, 200, 1).setBinding(value -> {
            double newValue = (double)value.intValue() / 100.0;
            CombatifyClient.attackIndicatorMaxValue.method_41748((Object)newValue);
        }, () -> (int)((Double)CombatifyClient.attackIndicatorMaxValue.method_41753() * 100.0))).addOption((OptionBuilder)builder.createIntegerOption(Combatify.id("general.attack_indicator_min_value")).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.attackIndicatorMinValue")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.attack_indicator_min_value.tooltip")).setDefaultValue(Integer.valueOf(130)).setValueFormatter(ControlValueFormatterImpls.percentage()).setRange(0, 200, 1).setBinding(value -> {
            double newValue = (double)value.intValue() / 100.0;
            CombatifyClient.attackIndicatorMinValue.method_41748((Object)newValue);
        }, () -> (int)((Double)CombatifyClient.attackIndicatorMinValue.method_41753() * 100.0))).addOption((OptionBuilder)builder.createEnumOption(Combatify.id("general.rhythmic_attacks"), class_9851.class).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.rhythmicAttack")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.rhythmic_attacks.tooltip")).setDefaultValue((Enum)class_9851.field_52396).setElementNameProvider(triState -> switch (triState) {
            default -> throw new MatchException(null, null);
            case class_9851.field_52394 -> class_5244.field_24332;
            case class_9851.field_52395 -> class_5244.field_24333;
            case class_9851.field_52396 -> class_2561.method_43471((String)"options.context_decided");
        }).setBinding(arg_0 -> CombatifyClient.rhythmicAttacks.method_41748(arg_0), () -> CombatifyClient.rhythmicAttacks.method_41753())).addOption((OptionBuilder)builder.createEnumOption(Combatify.id("general.augmented_arm_height"), class_9851.class).setStorageHandler(this.vanillaStorage).setName((class_2561)class_2561.method_43471((String)"options.augmentedArmHeight")).setTooltip((class_2561)class_2561.method_43471((String)"sodium.options.augmented_arm_height.tooltip")).setDefaultValue((Enum)class_9851.field_52396).setElementNameProvider(triState -> switch (triState) {
            default -> throw new MatchException(null, null);
            case class_9851.field_52394 -> class_5244.field_24332;
            case class_9851.field_52395 -> class_5244.field_24333;
            case class_9851.field_52396 -> class_2561.method_43471((String)"options.context_decided");
        }).setBinding(arg_0 -> CombatifyClient.augmentedArmHeight.method_41748(arg_0), () -> CombatifyClient.augmentedArmHeight.method_41753())));
        return generalPage;
    }
}

