/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import java.util.UUID;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.EatingInterruptionMode;
import net.atlas.combatify.extensions.LivingEntityExtensions;
import net.atlas.combatify.networking.NetworkingHandler;
import net.atlas.combatify.util.MethodHandler;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_10707;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1679;
import net.minecraft.class_1767;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_8110;
import net.minecraft.class_8710;
import net.minecraft.class_9307;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class}, priority=1400)
public abstract class LivingEntityMixin
extends class_1297
implements LivingEntityExtensions {
    @Unique
    private int crouchBlockingTicks = 0;
    @Unique
    private double piercingNegation;
    @Unique
    private class_1796 fallbackCooldowns = MethodHandler.createItemCooldowns();
    @Unique
    protected int attackStrengthMaxValue;
    @Unique
    class_1309 thisEntity = (class_1309)class_1309.class.cast(this);
    @Shadow
    protected int field_6222;
    @Shadow
    public int field_6273;

    public LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Shadow
    public abstract class_1799 method_6030();

    @Shadow
    public abstract void method_48761(double var1, double var3);

    @Shadow
    public abstract boolean method_6039();

    @Shadow
    public abstract double method_45325(class_6880<class_1320> var1);

    @Override
    public int combatify$getCrouchBlockingTicks() {
        return this.crouchBlockingTicks;
    }

    @Override
    public class_1796 combatify$getFallbackCooldowns() {
        return this.fallbackCooldowns;
    }

    @Inject(method={"method_75124"}, at={@At(value="HEAD")})
    public void reset(CallbackInfo ci) {
        if (!(this.thisEntity instanceof class_1657)) {
            this.resetAttackStrengthTicker(false);
        }
    }

    @Inject(method={"method_5773"}, at={@At(value="RETURN")})
    public void tickCooldowns(CallbackInfo ci) {
        this.fallbackCooldowns.method_7903();
        this.crouchBlockingTicks = MethodHandler.canCrouchShield(this.thisEntity) != null ? ++this.crouchBlockingTicks : 0;
        if (!(this.thisEntity instanceof class_1657)) {
            ++this.field_6273;
        }
    }

    @Override
    public void combatify$resetAttackStrengthTicker(boolean hit) {
        this.resetAttackStrengthTicker(false);
    }

    @Override
    public void combatify$resetAttackStrengthTicker(boolean hit, boolean force) {
        this.resetAttackStrengthTicker(force);
    }

    @Unique
    public void resetAttackStrengthTicker(boolean force) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return;
        }
        if (Combatify.CONFIG.attackSpeed() == false && this.method_45325((class_6880<class_1320>)class_5134.field_23723) - 1.5 >= 20.0 || Combatify.CONFIG.instaAttack().booleanValue()) {
            return;
        }
        int chargeTicks = MethodHandler.getCurrentItemAttackStrengthDelay((class_1309)class_1309.class.cast(this));
        if (force || chargeTicks > this.attackStrengthMaxValue - this.field_6273) {
            if (Combatify.CONFIG.enableDebugLogging().booleanValue()) {
                Combatify.LOGGER.info("Ticks for charge: " + chargeTicks);
            }
            this.attackStrengthMaxValue = chargeTicks;
            this.field_6273 = 0;
        }
    }

    @Override
    public boolean combatify$isAttackAvailable(float baseTime, class_1799 weapon) {
        return (float)this.attackStrengthMaxValue - ((float)this.field_6273 + baseTime) <= 0.0f;
    }

    @ModifyReturnValue(method={"method_6039"}, at={@At(value="RETURN")})
    public boolean isBlocking(boolean original) {
        return !MethodHandler.getBlockingItem(this.thisEntity).stack().method_7960();
    }

    @Inject(method={"method_6060"}, at={@At(value="HEAD")}, cancellable=true)
    public void blockedByShield(class_1309 target, CallbackInfo ci) {
        ci.cancel();
    }

    @Override
    public void combatify$setPiercingNegation(double negation) {
        this.piercingNegation = negation;
    }

    @Override
    public double combatify$getPiercingNegation() {
        return this.piercingNegation;
    }

    @ModifyConstant(method={"method_48922"}, constant={@Constant(intValue=20, ordinal=0)})
    private int syncInvulnerability(int x) {
        return 10;
    }

    @WrapOperation(method={"method_67346"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_6090(Lnet/minecraft/class_3218;Lnet/minecraft/class_1309;)V")})
    public void applyBlockEffects(class_1309 instance, class_3218 serverLevel, class_1309 attacker, Operation<Void> original, @Local(ordinal=0, argsOnly=true) class_1282 source) {
        original.call(new Object[]{instance, serverLevel, attacker});
        MethodHandler.blockedByShield(serverLevel, instance, attacker, source);
    }

    @WrapOperation(method={"method_67346"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_10707;method_67202(Lnet/minecraft/class_1282;FD)F")})
    public float applyBanner(class_10707 instance, class_1282 damageSource, float amount, double angle, Operation<Float> original, @Local(ordinal=0) class_1799 blockingItem) {
        float result = ((Float)original.call(new Object[]{instance, damageSource, Float.valueOf(amount), angle})).floatValue();
        class_9307 bannerPatternLayers = (class_9307)blockingItem.method_58695(class_9334.field_49619, (Object)class_9307.field_49404);
        class_1767 dyeColor = (class_1767)blockingItem.method_58694(class_9334.field_49620);
        if (MethodHandler.getBlocking(blockingItem).hasBanner() && (!bannerPatternLayers.comp_2428().isEmpty() || dyeColor != null)) {
            class_10707.class_10708 bannerBoost = new class_10707.class_10708(((class_10707.class_10708)instance.comp_3588().getFirst()).comp_3638(), Optional.empty(), 5.0f, 1.0f);
            result = class_3532.method_15363((float)(result + bannerBoost.method_67206(damageSource, amount, angle)), (float)0.0f, (float)amount);
        }
        return result;
    }

    @WrapOperation(method={"method_67346"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1282;method_48789(Lnet/minecraft/class_6862;)Z")})
    public boolean applyArrowDisable(class_1282 instance, class_6862<class_8110> tagKey, Operation<Boolean> original, @Local(ordinal=0, argsOnly=true) class_3218 serverLevel) {
        if (((Boolean)original.call(new Object[]{instance, tagKey})).booleanValue()) {
            class_1297 class_12972 = instance.method_5526();
            int n = 0;
            block4: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1667.class, class_1679.class}, (Object)class_12972, n)) {
                    case 0: {
                        class_1667 arrow = (class_1667)class_12972;
                        if (!Combatify.CONFIG.arrowDisableMode().satisfiesConditions((class_1665)arrow)) {
                            n = 1;
                            continue block4;
                        }
                        MethodHandler.arrowDisable(serverLevel, this.thisEntity, instance, (class_1665)arrow, MethodHandler.getBlockingItem(this.thisEntity).stack());
                        break block4;
                    }
                    case 1: {
                        class_1679 arrow = (class_1679)class_12972;
                        if (!Combatify.CONFIG.arrowDisableMode().satisfiesConditions((class_1665)arrow)) {
                            n = 2;
                            continue block4;
                        }
                        MethodHandler.arrowDisable(serverLevel, this.thisEntity, instance, (class_1665)arrow, MethodHandler.getBlockingItem(this.thisEntity).stack());
                        break block4;
                    }
                }
                break;
            }
            return true;
        }
        return false;
    }

    @WrapOperation(method={"method_67346"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_6058()Lnet/minecraft/class_1268;")})
    public class_1268 spoofUsedHand(class_1309 instance, Operation<class_1268> original, @Local(ordinal=0, argsOnly=true) class_3218 serverLevel) {
        class_1268 interactionHand = (class_1268)original.call(new Object[]{instance});
        if (MethodHandler.getBlockingItem(instance).useHand() != null) {
            return MethodHandler.getBlockingItem(instance).useHand();
        }
        return interactionHand;
    }

    @Inject(method={"method_64397"}, at={@At(value="FIELD", target="Lnet/minecraft/class_1309;field_6008:I", ordinal=1, shift=At.Shift.AFTER)})
    public void injectEatingInterruption(class_3218 serverLevel, class_1282 source, float f, CallbackInfoReturnable<Boolean> cir) {
        boolean canInterrupt;
        class_1297 entity = source.method_5529();
        boolean bl = canInterrupt = this.thisEntity.method_6115() && (this.method_6030().method_7976() == class_1839.field_8950 || this.method_6030().method_7976() == class_1839.field_8946);
        if (entity instanceof class_1309 && canInterrupt) {
            EatingInterruptionMode eatingInterruptionMode = Combatify.CONFIG.eatingInterruptionMode();
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FULL_RESET", "DELAY"}, (EatingInterruptionMode)eatingInterruptionMode, n)) {
                case 0: {
                    int n2 = this.thisEntity.method_6030().method_7935(this.thisEntity);
                    break;
                }
                case 1: {
                    int n2 = this.field_6222 + this.field_6008;
                    break;
                }
                default: {
                    int n2 = this.field_6222 = this.field_6222;
                }
            }
            if (Combatify.CONFIG.eatingInterruptionMode() != EatingInterruptionMode.OFF) {
                for (UUID playerUUID : Combatify.moddedPlayers) {
                    class_1657 class_16572 = serverLevel.method_18470(playerUUID);
                    if (!(class_16572 instanceof class_3222)) continue;
                    class_3222 serverPlayer = (class_3222)class_16572;
                    ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new NetworkingHandler.RemainingUseSyncPacket(this.method_5628(), this.field_6222));
                }
            }
        }
    }

    @ModifyExpressionValue(method={"method_64397"}, at={@At(value="CONSTANT", args={"floatValue=10.0F"}, ordinal=0)})
    public float changeIFrames(float constant) {
        return constant - 10.0f;
    }

    @WrapOperation(method={"method_64397"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_6005(DDD)V")})
    public void modifyKB(class_1309 instance, double d, double e, double f, Operation<Void> original, @Local(ordinal=0, argsOnly=true) class_1282 source, @Local(argsOnly=true) float amount, @Share(value="blocked") LocalBooleanRef bl) {
        if (bl.get() && amount > 0.0f) {
            this.method_48761(e, f);
        }
        Combatify.CONFIG.knockbackMode().runKnockback(instance, source, d, e, f, (xva$0, xva$1, xva$2, xva$3) -> {
            Void cfr_ignored_0 = (Void)original.call(new Object[]{xva$0, xva$1, xva$2, xva$3});
        });
    }

    @ModifyReceiver(method={"method_64397"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1799;method_58694(Lnet/minecraft/class_9331;)Ljava/lang/Object;")})
    public class_1799 modifyBlockingItem(class_1799 instance, class_9331 dataComponentType) {
        return MethodHandler.getBlockingItem(this.thisEntity).stack();
    }

    @ModifyExpressionValue(method={"method_6019"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_6115()Z")})
    public boolean addCooldownCheck(boolean original, @Local(ordinal=0) class_1799 itemStack) {
        return original || MethodHandler.getCooldowns(this.thisEntity).method_7904(itemStack);
    }

    @ModifyExpressionValue(method={"method_67346"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1665;method_7447()B")})
    public byte ignorePiercing(byte original) {
        return Combatify.CONFIG.arrowDisableMode().pierceArrowsBlocked() ? (byte)0 : original;
    }

    @ModifyReturnValue(method={"method_62821"}, at={@At(value="RETURN")})
    public class_1799 removeMojangStupidity(class_1799 original) {
        return original == null && !MethodHandler.getBlockingItem(this.thisEntity).stack().method_7960() ? MethodHandler.getBlockingItem(this.thisEntity).stack() : original;
    }

    @WrapOperation(method={"method_75122"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_6005(DDD)V")})
    public void knockback(class_1309 instance, double d, double e, double f, Operation<Void> original) {
        class_1799 itemStack = this.method_59958();
        Combatify.CONFIG.knockbackMode().runKnockback(instance, itemStack.method_75220(this.thisEntity, () -> this.method_48923().method_48812(this.thisEntity)), d, e, f, (xva$0, xva$1, xva$2, xva$3) -> {
            Void cfr_ignored_0 = (Void)original.call(new Object[]{xva$0, xva$1, xva$2, xva$3});
        });
    }

    @Inject(method={"method_75122"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_18799(Lnet/minecraft/class_243;)V")})
    public void resetSprint(class_1297 entity, float f, class_243 vec3, CallbackInfo ci) {
        if (this.method_5624()) {
            this.method_5728(false);
        }
    }

    @Override
    public boolean combatify$hasEnabledShieldOnCrouch() {
        return true;
    }

    @Override
    public void combatify$setUseItemRemaining(int ticks) {
        this.field_6222 = ticks;
    }
}

